/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.roster.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.core.Jid;

public final class Contact
implements Comparable<Contact> {
    @XmlElement
    private final List<String> group = new ArrayList<String>();
    @XmlAttribute
    Boolean approved;
    @XmlJavaTypeAdapter(value=PendingAdapter.class)
    @XmlAttribute
    Boolean ask;
    @XmlAttribute
    private Jid jid;
    @XmlAttribute
    private String name;
    @XmlAttribute
    private Subscription subscription;

    private Contact() {
    }

    public Contact(Jid jid) {
        this.jid = jid;
    }

    public Contact(Jid jid, String name) {
        this.jid = jid;
        this.name = name;
    }

    public Contact(Jid jid, String name, String ... groups) {
        this.jid = jid;
        this.name = name;
        this.group.addAll(Arrays.asList(groups));
    }

    public Contact(Jid jid, String name, List<String> groups) {
        this.jid = jid;
        this.name = name;
        this.group.addAll(groups);
    }

    public Contact(Jid jid, String name, boolean isPending, Subscription subscription, String ... groups) {
        this.jid = jid;
        this.name = name;
        this.ask = isPending;
        this.subscription = subscription;
        this.group.addAll(Arrays.asList(groups));
    }

    public Jid getJid() {
        return this.jid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public List<String> getGroups() {
        return this.group;
    }

    public boolean isPending() {
        return this.ask != null && this.ask != false;
    }

    public boolean isApproved() {
        return this.approved != null && this.approved != false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contact)) {
            return false;
        }
        Contact other = (Contact)o;
        return (this.jid == null ? other.jid == null : this.jid.equals(other.jid)) && (this.name == null ? other.name == null : this.name.equals(other.name)) && (this.subscription == null ? other.subscription == null : this.subscription.equals((Object)other.subscription)) && (this.approved == null ? other.approved == null : this.approved.equals(other.approved)) && (this.ask == null ? other.ask == null : this.ask.equals(other.ask)) && this.group.containsAll(other.group) && other.group.containsAll(this.group);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.jid == null ? 0 : this.jid.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.subscription == null ? 0 : this.subscription.hashCode());
        result = 31 * result + (this.approved == null ? 0 : this.approved.hashCode());
        result = 31 * result + (this.ask == null ? 0 : this.ask.hashCode());
        result = 31 * result + this.group.hashCode();
        return result;
    }

    @Override
    public int compareTo(Contact o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            int result = this.name != null ? (o.name != null ? this.name.compareToIgnoreCase(o.name) : -1) : (o.name != null ? 1 : 0);
            if (result == 0) {
                result = this.subscription != null ? (o.subscription != null ? this.subscription.compareTo(o.subscription) : -1) : (o.subscription != null ? 1 : 0);
            }
            if (result == 0) {
                result = Boolean.compare(this.isPending(), o.isPending());
            }
            return result;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.jid.toString());
        if (this.name != null) {
            sb.append(" (").append(this.name).append(")");
        }
        return sb.toString();
    }

    private static final class PendingAdapter
    extends XmlAdapter<Ask, Boolean> {
        private PendingAdapter() {
        }

        public Boolean unmarshal(Ask v) throws Exception {
            return v != null && v == Ask.SUBSCRIBE;
        }

        public Ask marshal(Boolean v) throws Exception {
            return v != null ? Ask.SUBSCRIBE : null;
        }
    }

    @XmlEnum
    private static enum Ask {
        SUBSCRIBE;

    }

    @XmlEnum
    public static enum Subscription {
        BOTH,
        FROM,
        TO,
        NONE,
        REMOVE;

    }
}

