/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class FaceBookSaslClient
implements SaslClient {
    private final String apiKey;
    private final String accessToken;

    public FaceBookSaslClient(String apiKey, String accessToken) throws SaslException {
        if (apiKey == null || accessToken == null) {
            throw new SaslException("PLAIN: authorization ID and password must be specified");
        }
        this.apiKey = apiKey;
        this.accessToken = accessToken;
    }

    @Override
    public String getMechanismName() {
        return "X-FACEBOOK-PLATFORM";
    }

    @Override
    public boolean hasInitialResponse() {
        return false;
    }

    private Map<String, String> getQueryMap(String query) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params = query.split("\\&")) {
            String[] fields = param.split("=", 2);
            map.put(fields[0], fields.length > 1 ? fields[1] : null);
        }
        return map;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        Map<String, String> parameters = this.getQueryMap(new String(challenge));
        String version = "1.0";
        String nonce = parameters.get("nonce");
        String method = parameters.get("method");
        long callId = 0L;
        try {
            String composedResponse = "api_key=" + URLEncoder.encode(this.apiKey, "utf-8") + "&call_id=" + callId + "&method=" + URLEncoder.encode(method, "utf-8") + "&nonce=" + URLEncoder.encode(nonce, "utf-8") + "&access_token=" + URLEncoder.encode(this.accessToken, "utf-8") + "&v=" + URLEncoder.encode(version, "utf-8");
            return composedResponse.getBytes("utf-8");
        }
        catch (Exception e) {
            throw new SaslException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return new byte[0];
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return new byte[0];
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

