/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza;

import java.util.Arrays;
import java.util.Collections;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.roster.model.Roster;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.errors.Condition;

public class MessageTest
extends XmlTest {
    protected MessageTest() throws JAXBException, XMLStreamException {
        super(Message.class);
    }

    @Test
    public void unmarshalSingleBody() throws XMLStreamException, JAXBException {
        String xml = "<message\n    from='juliet@example.com/balcony'\n    id='b4vs9km4'\n    to='romeo@example.net'\n    type='chat'\n    xml:lang='en'>\n  <body>Wherefore art thou, Romeo?</body>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        Assert.assertEquals((String)message.getFrom().toString(), (String)"juliet@example.com/balcony");
        Assert.assertEquals((String)message.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)message.getType(), (Object)AbstractMessage.Type.CHAT);
        Assert.assertEquals((String)message.getId(), (String)"b4vs9km4");
        Assert.assertEquals((String)message.getLanguage(), (String)"en");
        Assert.assertEquals((String)message.getBody(), (String)"Wherefore art thou, Romeo?");
    }

    @Test
    public void unmarshalMultipleBodies() throws XMLStreamException, JAXBException {
        String xml = "<message\n    from='juliet@example.com/balcony'\n    id='z94nb37h'\n    to='romeo@example.net'\n    type='chat'\n    xml:lang='en'>\n  <body>Wherefore art thou, Romeo?</body>\n  <body xml:lang='de'>Wo bist du, Romeo?</body>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        Assert.assertEquals((String)message.getFrom().toString(), (String)"juliet@example.com/balcony");
        Assert.assertEquals((String)message.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)message.getType(), (Object)AbstractMessage.Type.CHAT);
        Assert.assertEquals((String)message.getId(), (String)"z94nb37h");
        Assert.assertEquals((String)message.getLanguage(), (String)"en");
        Assert.assertEquals((String)message.getBody(), (String)"Wherefore art thou, Romeo?");
        Assert.assertEquals((String)((AbstractMessage.Body)message.getBodies().get(1)).getText(), (String)"Wo bist du, Romeo?");
    }

    @Test
    public void unmarshalSingleSubject() throws XMLStreamException, JAXBException {
        String xml = "<message\n    from='juliet@example.com/balcony'\n    id='c8xg3nf8'\n    to='romeo@example.net'\n    type='chat'\n    xml:lang='en'>\n  <subject>I implore you!</subject>\n  <body>Wherefore art thou, Romeo?</body>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        Assert.assertEquals((String)message.getFrom().toString(), (String)"juliet@example.com/balcony");
        Assert.assertEquals((String)message.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)message.getType(), (Object)AbstractMessage.Type.CHAT);
        Assert.assertEquals((String)message.getId(), (String)"c8xg3nf8");
        Assert.assertEquals((String)message.getLanguage(), (String)"en");
        Assert.assertEquals((String)message.getSubject(), (String)"I implore you!");
        Assert.assertEquals((String)message.getBody(), (String)"Wherefore art thou, Romeo?");
    }

    @Test
    public void unmarshalMultipleSubjects() throws XMLStreamException, JAXBException {
        String xml = "<message\n    from='juliet@example.com/balcony'\n    id='jk3v47gw'\n    to='romeo@example.net'\n    type='chat'\n    xml:lang='en'>\n  <subject>I implore you!</subject>\n  <subject xml:lang='de'>Ich flehe dich an!</subject>\n  <body>Wherefore art thou, Romeo?</body>\n  <body xml:lang='cs'>Wo bist du, Romeo?</body>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        Assert.assertEquals((String)message.getFrom().toString(), (String)"juliet@example.com/balcony");
        Assert.assertEquals((String)message.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)message.getType(), (Object)AbstractMessage.Type.CHAT);
        Assert.assertEquals((String)message.getId(), (String)"jk3v47gw");
        Assert.assertEquals((String)message.getLanguage(), (String)"en");
        Assert.assertEquals((String)message.getSubject(), (String)"I implore you!");
        Assert.assertEquals((String)((AbstractMessage.Subject)message.getSubjects().get(1)).getText(), (String)"Ich flehe dich an!");
        Assert.assertEquals((String)message.getBody(), (String)"Wherefore art thou, Romeo?");
        Assert.assertEquals((String)((AbstractMessage.Body)message.getBodies().get(1)).getText(), (String)"Wo bist du, Romeo?");
    }

    @Test
    public void unmarshalThread() throws XMLStreamException, JAXBException {
        String xml = "<message\n    from='juliet@example.com/balcony'\n    to='romeo@example.net'\n    type='chat'\n    xml:lang='en'>\n  <thread parent='e0ffe42b28561960c6b12b944a092794b9683a38'>0e3141cd80894871a68e6fe6b1ec56fa</thread>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        Assert.assertEquals((String)message.getFrom().toString(), (String)"juliet@example.com/balcony");
        Assert.assertEquals((String)message.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)message.getType(), (Object)AbstractMessage.Type.CHAT);
        Assert.assertNull((Object)message.getId());
        Assert.assertEquals((String)message.getLanguage(), (String)"en");
        Assert.assertEquals((String)message.getThread(), (String)"0e3141cd80894871a68e6fe6b1ec56fa");
        Assert.assertEquals((String)message.getParentThread(), (String)"e0ffe42b28561960c6b12b944a092794b9683a38");
    }

    @Test
    public void marshalChatMessage() throws JAXBException, XMLStreamException {
        Message message = new Message(Jid.valueOf((String)"juliet@example.com"), AbstractMessage.Type.CHAT);
        String xml = this.marshal(message);
        Assert.assertEquals((String)xml, (String)"<message to=\"juliet@example.com\" type=\"chat\"></message>");
    }

    @Test
    public void marshalGroupChatMessage() throws JAXBException, XMLStreamException {
        Message message = new Message(Jid.valueOf((String)"juliet@example.com"), AbstractMessage.Type.GROUPCHAT);
        String xml = this.marshal(message);
        Assert.assertEquals((String)xml, (String)"<message to=\"juliet@example.com\" type=\"groupchat\"></message>");
    }

    @Test
    public void marshalNormalMessage() throws JAXBException, XMLStreamException {
        Message message = new Message(Jid.valueOf((String)"juliet@example.com"), AbstractMessage.Type.NORMAL);
        String xml = this.marshal(message);
        Assert.assertEquals((String)xml, (String)"<message to=\"juliet@example.com\" type=\"normal\"></message>");
    }

    @Test
    public void marshalHeadlineMessage() throws JAXBException, XMLStreamException {
        Message message = new Message(Jid.valueOf((String)"juliet@example.com"), AbstractMessage.Type.HEADLINE);
        String xml = this.marshal(message);
        Assert.assertEquals((String)xml, (String)"<message to=\"juliet@example.com\" type=\"headline\"></message>");
    }

    @Test
    public void marshalErrorMessage() throws JAXBException, XMLStreamException {
        Message message = new Message(Jid.valueOf((String)"juliet@example.com"), AbstractMessage.Type.ERROR, "test", null, null, null, null, null, null, null, new StanzaError(Condition.CONFLICT));
        String xml = this.marshal(message);
        Assert.assertEquals((String)xml, (String)"<message to=\"juliet@example.com\" type=\"error\"><body>test</body><error type=\"cancel\"><conflict xmlns=\"urn:ietf:params:xml:ns:xmpp-stanzas\"></conflict></error></message>");
    }

    @Test
    public void marshalMessage() throws JAXBException, XMLStreamException {
        Message message = new Message(new Jid("to", "domain"), AbstractMessage.Type.CHAT, Collections.emptyList(), null, null, null, "id", new Jid("from", "domain"), null, null, null);
        String xml = this.marshal(message);
        Assert.assertEquals((String)xml, (String)"<message from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"chat\"></message>");
    }

    @Test
    public void marshalMessageThread() throws JAXBException, XMLStreamException {
        Message message = new Message(new Jid("to", "domain"), AbstractMessage.Type.CHAT, Collections.emptyList(), null, "thread", null, "id", new Jid("from", "domain"), null, null, null);
        String xml = this.marshal(message);
        Assert.assertEquals((String)xml, (String)"<message from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"chat\"><thread>thread</thread></message>");
    }

    @Test
    public void marshalMessageParentThread() throws JAXBException, XMLStreamException {
        Message message = new Message(new Jid("to", "domain"), AbstractMessage.Type.CHAT, Collections.emptyList(), null, "thread", "parentThread", "id", new Jid("from", "domain"), null, null, null);
        String xml = this.marshal(message);
        Assert.assertEquals((String)xml, (String)"<message from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"chat\"><thread parent=\"parentThread\">thread</thread></message>");
    }

    @Test
    public void marshalMessageParentThreadWithoutThread() throws JAXBException, XMLStreamException {
        Message message = new Message(new Jid("to", "domain"), AbstractMessage.Type.CHAT, Collections.emptyList(), null, null, "parentThread", "id", new Jid("from", "domain"), null, null, null);
        String xml = this.marshal(message);
        Assert.assertEquals((String)xml, (String)"<message from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"chat\"><thread parent=\"parentThread\"></thread></message>");
    }

    @Test
    public void marshalMessageBody() throws JAXBException, XMLStreamException {
        Message message = new Message(new Jid("to", "domain"), AbstractMessage.Type.CHAT, Arrays.asList(new AbstractMessage.Body("body", "de"), new AbstractMessage.Body("body2", "fr")), null, null, null, "id", new Jid("from", "domain"), null, null, null);
        String xml = this.marshal(message);
        Assert.assertEquals((String)xml, (String)"<message from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"chat\"><body xml:lang=\"de\">body</body><body xml:lang=\"fr\">body2</body></message>");
    }

    @Test
    public void marshalMessageSubject() throws JAXBException, XMLStreamException {
        Message message = new Message(new Jid("to", "domain"), AbstractMessage.Type.CHAT, null, Arrays.asList(new AbstractMessage.Subject("subject1", "de"), new AbstractMessage.Subject("subject2", "fr")), null, null, "id", new Jid("from", "domain"), null, null, null);
        String xml = this.marshal(message);
        Assert.assertEquals((String)xml, (String)"<message from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"chat\"><subject xml:lang=\"de\">subject1</subject><subject xml:lang=\"fr\">subject2</subject></message>");
    }

    @Test
    public void testWithFrom() throws JAXBException, XMLStreamException {
        Message message = new Message(new Jid("to", "domain"), AbstractMessage.Type.CHAT, "body", "subject", "thread", null, "id", null, null, Arrays.asList(new Roster()), null);
        Message withFrom = message.withFrom(Jid.valueOf((String)"from"));
        Assert.assertEquals((Object)withFrom.getType(), (Object)AbstractMessage.Type.CHAT);
        Assert.assertEquals((String)withFrom.getId(), (String)"id");
        Assert.assertEquals((Object)withFrom.getFrom(), (Object)Jid.valueOf((String)"from"));
        Assert.assertNotNull((Object)withFrom.getExtension(Roster.class));
    }
}

