/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemDiscovery;
import rocks.xmpp.extensions.disco.model.items.ItemNode;

public class ServiceDiscoveryTest
extends XmlTest {
    protected ServiceDiscoveryTest() throws JAXBException, XMLStreamException {
        super(IQ.class, ItemDiscovery.class, InfoDiscovery.class);
    }

    @Test
    public void unmarshalServiceDiscoveryResponse() throws XMLStreamException, JAXBException {
        String xml = "<iq type='result'\n    from='plays.shakespeare.lit'\n    to='romeo@montague.net/orchard'\n    id='info1'>\n  <query xmlns='http://jabber.org/protocol/disco#info'>\n    <identity\n        category='conference'\n        type='text'\n        name='Play-Specific Chatrooms'/>\n    <identity\n        category='directory'\n        type='chatroom'\n        name='Play-Specific Chatrooms'/>\n    <feature var='http://jabber.org/protocol/disco#info'/>\n    <feature var='http://jabber.org/protocol/disco#items'/>\n    <feature var='http://jabber.org/protocol/muc'/>\n    <feature var='jabber:iq:register'/>\n    <feature var='jabber:iq:search'/>\n    <feature var='jabber:iq:time'/>\n    <feature var='jabber:iq:version'/>\n  </query>\n</iq>";
        IQ iq = this.unmarshal(xml, IQ.class);
        InfoDiscovery serviceDiscovery = (InfoDiscovery)iq.getExtension(InfoDiscovery.class);
        Assert.assertNotNull((Object)serviceDiscovery);
        Assert.assertEquals((int)serviceDiscovery.getIdentities().size(), (int)2);
        Assert.assertEquals((int)serviceDiscovery.getFeatures().size(), (int)7);
        Identity identity1 = new Identity("conference", "text", "Play-Specific Chatrooms");
        Identity identity2 = new Identity("directory", "chatroom", "Play-Specific Chatrooms");
        Assert.assertTrue((boolean)serviceDiscovery.getIdentities().contains(identity1));
        Assert.assertTrue((boolean)serviceDiscovery.getIdentities().contains(identity2));
        Assert.assertTrue((boolean)serviceDiscovery.getFeatures().contains(new Feature("http://jabber.org/protocol/disco#info")));
        Assert.assertTrue((boolean)serviceDiscovery.getFeatures().contains(new Feature("http://jabber.org/protocol/disco#items")));
        Assert.assertTrue((boolean)serviceDiscovery.getFeatures().contains(new Feature("http://jabber.org/protocol/muc")));
        Assert.assertTrue((boolean)serviceDiscovery.getFeatures().contains(new Feature("jabber:iq:register")));
        Assert.assertTrue((boolean)serviceDiscovery.getFeatures().contains(new Feature("jabber:iq:search")));
        Assert.assertTrue((boolean)serviceDiscovery.getFeatures().contains(new Feature("jabber:iq:time")));
        Assert.assertTrue((boolean)serviceDiscovery.getFeatures().contains(new Feature("jabber:iq:version")));
    }

    @Test
    public void unmarshalServiceDiscoveryItemResponse() throws XMLStreamException, JAXBException {
        String xml = "<iq type='result'\n    from='catalog.shakespeare.lit'\n    to='romeo@montague.net/orchard'\n    id='items2'>\n  <query xmlns='http://jabber.org/protocol/disco#items' node='http://jabber.org/protocol/tune'>\n    <item jid='catalog.shakespeare.lit'\n          node='books'\n          name='Books by and about Shakespeare'/>\n    <item jid='catalog.shakespeare.lit'\n          node='clothing'\n          name='Wear your literary taste with pride'/>\n    <item jid='catalog.shakespeare.lit'\n          node='music'\n          name='Music from the time of Shakespeare'/>\n  </query>\n</iq>\n";
        IQ iq = this.unmarshal(xml, IQ.class);
        ItemNode itemNode = (ItemNode)iq.getExtension(ItemDiscovery.class);
        Assert.assertNotNull((Object)itemNode);
        Assert.assertEquals((int)itemNode.getItems().size(), (int)3);
        Assert.assertEquals((Object)((Item)itemNode.getItems().get(0)).getJid(), (Object)Jid.valueOf((String)"catalog.shakespeare.lit"));
        Assert.assertEquals((String)((Item)itemNode.getItems().get(0)).getNode(), (String)"books");
        Assert.assertEquals((String)((Item)itemNode.getItems().get(0)).getName(), (String)"Books by and about Shakespeare");
        Assert.assertEquals((Object)((Item)itemNode.getItems().get(1)).getJid(), (Object)Jid.valueOf((String)"catalog.shakespeare.lit"));
        Assert.assertEquals((String)((Item)itemNode.getItems().get(1)).getNode(), (String)"clothing");
        Assert.assertEquals((String)((Item)itemNode.getItems().get(1)).getName(), (String)"Wear your literary taste with pride");
        Assert.assertEquals((Object)((Item)itemNode.getItems().get(2)).getJid(), (Object)Jid.valueOf((String)"catalog.shakespeare.lit"));
        Assert.assertEquals((String)((Item)itemNode.getItems().get(2)).getNode(), (String)"music");
        Assert.assertEquals((String)((Item)itemNode.getItems().get(2)).getName(), (String)"Music from the time of Shakespeare");
    }

    @Test
    public void unmarshalServiceDiscoveryExtension() throws JAXBException, XMLStreamException {
        String xml = "<iq type='result'\n    from='shakespeare.lit'\n    to='capulet.com'\n    id='disco1'>\n  <query xmlns='http://jabber.org/protocol/disco#info'>\n    <identity\n        category='server'\n        type='im'\n        name='shakespeare.lit jabber server'/>\n    <feature var='jabber:iq:register'/>\n    <x xmlns='jabber:x:data' type='result'>\n      <field var='FORM_TYPE' type='hidden'>\n        <value>http://jabber.org/network/serverinfo</value>\n      </field>\n      <field var='c2s_port'>\n        <value>5222</value>\n      </field>\n      <field var='c2s_port_ssl'>\n        <value>5223</value>\n      </field>\n      <field var='http_access'>\n        <value>http://shakespeare.lit/jabber</value>\n      </field>\n      <field var='ip_version'>\n        <value>ipv4</value>\n        <value>ipv6</value>\n      </field>\n      <field var='info_url'>\n        <value>http://shakespeare.lit/support.php</value>\n      </field>\n    </x>\n  </query>\n</iq>\n";
        IQ iq = this.unmarshal(xml, IQ.class);
        InfoNode infoDiscovery = (InfoNode)iq.getExtension(InfoDiscovery.class);
        Assert.assertNotNull((Object)infoDiscovery);
        Assert.assertEquals((int)infoDiscovery.getExtensions().size(), (int)1);
        Assert.assertEquals((Object)((DataForm)infoDiscovery.getExtensions().get(0)).getType(), (Object)DataForm.Type.RESULT);
    }

    @Test
    public void unmarshalServiceDiscoveryWithResultSet() throws JAXBException, XMLStreamException {
        String xml = "<iq type='set' from='stpeter@jabber.org/roundabout' to='conference.jabber.org' id='ex3'>\n  <query xmlns='http://jabber.org/protocol/disco#items'>\n    <set xmlns='http://jabber.org/protocol/rsm'>\n      <max>20</max>\n      <after>4da91d4b330112f683dddaebf93180b1bd25e95f</after>\n    </set>\n  </query>\n</iq>\n";
        IQ iq = this.unmarshal(xml, IQ.class);
        ItemDiscovery itemDiscovery = (ItemDiscovery)iq.getExtension(ItemDiscovery.class);
        Assert.assertNotNull((Object)itemDiscovery);
        Assert.assertNotNull((Object)itemDiscovery.getResultSetManagement());
        Assert.assertEquals((Object)itemDiscovery.getResultSetManagement().getMaxSize(), (Object)20);
    }
}

