/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privatedata.rosternotes;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.privatedata.model.PrivateData;
import rocks.xmpp.extensions.privatedata.rosternotes.model.Annotation;

public class AnnotationsTest
extends XmlTest {
    protected AnnotationsTest() throws JAXBException, XMLStreamException {
        super(IQ.class, PrivateData.class, Annotation.class);
    }

    @Test
    public void unmarshalAnnotations() throws XMLStreamException, JAXBException {
        String xml = "<iq type='set' id='a1'>\n  <query xmlns='jabber:iq:private'>\n    <storage xmlns='storage:rosternotes'>\n      <note jid='hamlet@shakespeare.lit'\n            cdate='2004-09-24T15:23:21Z'\n            mdate='2004-09-24T15:23:21Z'>Seems to be a good writer</note>\n      <note jid='juliet@capulet.com'\n            cdate='2004-09-27T17:23:14Z'\n            mdate='2004-09-28T12:43:12Z'>Oh my sweetest love ...</note>\n    </storage>\n  </query>\n</iq>";
        IQ iq = this.unmarshal(xml, IQ.class);
        PrivateData privateData = (PrivateData)iq.getExtension(PrivateData.class);
        Assert.assertNotNull((Object)privateData);
        Assert.assertTrue((boolean)(privateData.getData() instanceof Annotation));
        Annotation annotations = (Annotation)privateData.getData();
        Assert.assertEquals((int)annotations.getNotes().size(), (int)2);
        Assert.assertEquals((Object)((Annotation.Note)annotations.getNotes().get(0)).getJid(), (Object)Jid.valueOf((String)"hamlet@shakespeare.lit"));
        Assert.assertEquals((String)((Annotation.Note)annotations.getNotes().get(0)).getValue(), (String)"Seems to be a good writer");
        Assert.assertNotNull((Object)((Annotation.Note)annotations.getNotes().get(0)).getCreationDate());
        Assert.assertNotNull((Object)((Annotation.Note)annotations.getNotes().get(0)).getModificationDate());
        Assert.assertEquals((Object)((Annotation.Note)annotations.getNotes().get(1)).getJid(), (Object)Jid.valueOf((String)"juliet@capulet.com"));
        Assert.assertEquals((String)((Annotation.Note)annotations.getNotes().get(1)).getValue(), (String)"Oh my sweetest love ...");
        Assert.assertNotNull((Object)((Annotation.Note)annotations.getNotes().get(1)).getCreationDate());
        Assert.assertNotNull((Object)((Annotation.Note)annotations.getNotes().get(1)).getModificationDate());
    }
}

