/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ThreadFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.core.BranchedInputStream;
import rocks.xmpp.core.BranchedOutputStream;
import rocks.xmpp.core.PrefixFreeCanonicalizationWriter;

public final class XmppUtils {
    private XmppUtils() {
    }

    public static XMLStreamWriter createXmppStreamWriter(XMLStreamWriter xmlStreamWriter, boolean isClientNamespace) throws XMLStreamException {
        return new PrefixFreeCanonicalizationWriter(xmlStreamWriter, isClientNamespace ? "jabber:client" : "jabber:server");
    }

    public static InputStream createBranchedInputStream(InputStream source, OutputStream target) {
        return new BranchedInputStream(source, target);
    }

    public static OutputStream createBranchedOutputStream(OutputStream out, OutputStream branch) {
        return new BranchedOutputStream(out, branch);
    }

    public static String hash(byte[] bytes) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("sha-1");
            messageDigest.reset();
            messageDigest.update(bytes);
            return String.format("%040x", new BigInteger(1, messageDigest.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static ThreadFactory createNamedThreadFactory(final String threadName) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, threadName);
                thread.setDaemon(true);
                return thread;
            }
        };
    }
}

