/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.sasl.scram;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.bind.DatatypeConverter;
import rocks.xmpp.core.sasl.scram.SaslPrep;

abstract class ScramBase {
    private static final byte[] INT1 = new byte[]{0, 0, 0, 1};
    private static final byte[] CLIENT_KEY = "Client Key".getBytes();
    protected final CallbackHandler callbackHandler;
    private final String hmacAlgorithm;
    private final String hashAlgorithm;
    protected boolean isComplete;
    protected String clientFirstMessageBare;
    protected String serverFirstMessage;
    protected String nonce;
    protected String channelBinding;
    private String mechanism = "SCRAM-";

    public ScramBase(String hashAlgorithm, CallbackHandler callbackHandler) {
        hashAlgorithm = hashAlgorithm.toUpperCase();
        if (!"SHA-1".equals(hashAlgorithm)) {
            throw new UnsupportedOperationException("Hash algorithm not supported.");
        }
        this.hmacAlgorithm = "HmacSHA1";
        this.mechanism = this.mechanism + hashAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.callbackHandler = callbackHandler;
    }

    public static byte[] xor(byte[] a, byte[] b) {
        byte[] c = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = (byte)(a[i] ^ b[i]);
        }
        return c;
    }

    public static String generateNonce() throws NoSuchAlgorithmException {
        byte[] nonce = new byte[16];
        SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
        ((Random)rand).nextBytes(nonce);
        return DatatypeConverter.printBase64Binary((byte[])nonce);
    }

    public static Map<Character, String> getAttributes(String str) {
        String[] parts;
        HashMap<Character, String> map = new HashMap<Character, String>();
        for (String part : parts = str.split(",")) {
            if (part.length() <= 1) continue;
            map.put(Character.valueOf(part.charAt(0)), part.substring(2));
        }
        return map;
    }

    public static String createClientFirstMessageBare(String username, String nonce) {
        return "n=" + username + ",r=" + nonce;
    }

    public byte[] computeClientSignature(byte[] clientKey, String authMessage) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] storedKey = this.computeStoredKey(clientKey);
        return this.hmac(storedKey, authMessage.getBytes());
    }

    public String computeAuthMessage() {
        String clientFinalMessageWithoutProof = "c=" + this.channelBinding + ",r=" + this.nonce;
        return this.clientFirstMessageBare + "," + this.serverFirstMessage + "," + clientFinalMessageWithoutProof;
    }

    public byte[] computeSaltedPassword(char[] password, byte[] salt, int iterationCount) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.hi(SaslPrep.prepare(new String(password)).getBytes(), salt, iterationCount);
    }

    public byte[] computeClientKey(byte[] saltedPassword) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.hmac(saltedPassword, CLIENT_KEY);
    }

    public byte[] computeStoredKey(byte[] clientKey) throws NoSuchAlgorithmException {
        return this.h(clientKey);
    }

    public byte[] h(byte[] str) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(this.hashAlgorithm);
        digest.update(str);
        return digest.digest();
    }

    public byte[] hmac(byte[] key, byte[] str) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(this.hmacAlgorithm);
        mac.init(new SecretKeySpec(key, this.hmacAlgorithm));
        mac.update(str);
        return mac.doFinal();
    }

    public byte[] hi(byte[] str, byte[] salt, int i) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] uPrev;
        Mac hmac = Mac.getInstance(this.hmacAlgorithm);
        hmac.init(new SecretKeySpec(str, this.hmacAlgorithm));
        hmac.update(salt);
        hmac.update(INT1);
        byte[] result = uPrev = hmac.doFinal();
        for (int c = 1; c < i; ++c) {
            hmac.update(uPrev);
            uPrev = hmac.doFinal();
            result = ScramBase.xor(result, uPrev);
        }
        return result;
    }

    public String getMechanismName() {
        return this.mechanism;
    }
}

