/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.StanzaError;

@XmlTransient
public abstract class AbstractIQ
extends Stanza {
    @XmlAttribute
    private final Type type;
    @XmlAnyElement(lax=true)
    private Object extension;

    protected AbstractIQ() {
        this.type = null;
    }

    protected AbstractIQ(Jid to, Type type, Object extension, String id, Jid from, String language, StanzaError error) {
        super(to, from, id == null ? UUID.randomUUID().toString() : id, language, error);
        this.type = Objects.requireNonNull(type, "type must not be null.");
        this.extension = extension;
    }

    public final Type getType() {
        return this.type;
    }

    @Override
    public final <T> T getExtension(Class<T> type) {
        if (this.extension != null && type != null && type.isAssignableFrom(this.extension.getClass())) {
            return (T)this.extension;
        }
        return null;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder("IQ");
        if (this.type != null) {
            sb.append("-").append(this.type.name().toLowerCase());
        }
        return sb.append(super.toString()).toString();
    }

    @Deprecated
    public final void setExtension(Object extension) {
        this.extension = extension;
    }

    public final boolean isRequest() {
        return EnumSet.of(Type.GET, Type.SET).contains((Object)this.type);
    }

    public final boolean isResponse() {
        return EnumSet.of(Type.RESULT, Type.ERROR).contains((Object)this.type);
    }

    @XmlType(name="iqType")
    public static enum Type {
        ERROR,
        GET,
        RESULT,
        SET;

    }
}

