/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model.errors;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.BadRequest;
import rocks.xmpp.core.stanza.model.errors.Conflict;
import rocks.xmpp.core.stanza.model.errors.FeatureNotImplemented;
import rocks.xmpp.core.stanza.model.errors.Forbidden;
import rocks.xmpp.core.stanza.model.errors.Gone;
import rocks.xmpp.core.stanza.model.errors.InternalServerError;
import rocks.xmpp.core.stanza.model.errors.ItemNotFound;
import rocks.xmpp.core.stanza.model.errors.JidMalformed;
import rocks.xmpp.core.stanza.model.errors.NotAcceptable;
import rocks.xmpp.core.stanza.model.errors.NotAllowed;
import rocks.xmpp.core.stanza.model.errors.NotAuthorized;
import rocks.xmpp.core.stanza.model.errors.PolicyViolation;
import rocks.xmpp.core.stanza.model.errors.RecipientUnavailable;
import rocks.xmpp.core.stanza.model.errors.Redirect;
import rocks.xmpp.core.stanza.model.errors.RegistrationRequired;
import rocks.xmpp.core.stanza.model.errors.RemoteServerNotFound;
import rocks.xmpp.core.stanza.model.errors.RemoteServerTimeout;
import rocks.xmpp.core.stanza.model.errors.ResourceConstraint;
import rocks.xmpp.core.stanza.model.errors.ServiceUnavailable;
import rocks.xmpp.core.stanza.model.errors.SubscriptionRequired;
import rocks.xmpp.core.stanza.model.errors.Text;
import rocks.xmpp.core.stanza.model.errors.UndefinedCondition;
import rocks.xmpp.core.stanza.model.errors.UnexpectedRequest;

@XmlSeeAlso(value={Text.class, BadRequest.class, Conflict.class, FeatureNotImplemented.class, Conflict.class, Forbidden.class, Gone.class, InternalServerError.class, ItemNotFound.class, JidMalformed.class, NotAcceptable.class, NotAllowed.class, NotAuthorized.class, PolicyViolation.class, RecipientUnavailable.class, Redirect.class, RegistrationRequired.class, RemoteServerNotFound.class, RemoteServerTimeout.class, ResourceConstraint.class, ServiceUnavailable.class, SubscriptionRequired.class, UndefinedCondition.class, UnexpectedRequest.class})
public abstract class Condition {
    public static final Condition BAD_REQUEST = new BadRequest();
    public static final Condition CONFLICT = new Conflict();
    public static final Condition FEATURE_NOT_IMPLEMENTED = new FeatureNotImplemented();
    public static final Condition FORBIDDEN = new Forbidden();
    public static final Condition INTERNAL_SERVER_ERROR = new InternalServerError();
    public static final Condition ITEM_NOT_FOUND = new ItemNotFound();
    public static final Condition JID_MALFORMED = new JidMalformed();
    public static final Condition NOT_ACCEPTABLE = new NotAcceptable();
    public static final Condition NOT_ALLOWED = new NotAllowed();
    public static final Condition NOT_AUTHORIZED = new NotAuthorized();
    public static final Condition POLICY_VIOLATION = new PolicyViolation();
    public static final Condition RECIPIENT_UNAVAILABLE = new RecipientUnavailable();
    public static final Condition REGISTRATION_REQUIRED = new RegistrationRequired();
    public static final Condition REMOTE_SERVER_NOT_FOUND = new RemoteServerNotFound();
    public static final Condition REMOTE_SERVER_TIMEOUT = new RemoteServerTimeout();
    public static final Condition RESOURCE_CONSTRAINT = new ResourceConstraint();
    public static final Condition SERVICE_UNAVAILABLE = new ServiceUnavailable();
    public static final Condition SUBSCRIPTION_REQUIRED = new SubscriptionRequired();
    public static final Condition UNDEFINED_CONDITION = new UndefinedCondition();
    public static final Condition UNEXPECTED_REQUEST = new UnexpectedRequest();
    private static final Map<Class<? extends Condition>, StanzaError.Type> ASSOCIATED_ERROR_TYPE = new HashMap<Class<? extends Condition>, StanzaError.Type>();
    @XmlValue
    final String value;

    Condition() {
        this(null);
    }

    Condition(String value) {
        this.value = value;
    }

    public static StanzaError.Type getErrorTypeByCondition(Condition condition) {
        return ASSOCIATED_ERROR_TYPE.get(condition.getClass());
    }

    public static Redirect redirect(String alternateAddress) {
        return new Redirect(alternateAddress);
    }

    public static Gone gone() {
        return new Gone();
    }

    public static Gone gone(String newAddress) {
        return new Gone(newAddress);
    }

    public final String toString() {
        return "<" + this.getClass().getSimpleName().replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase() + "/>";
    }

    static {
        ASSOCIATED_ERROR_TYPE.put(BadRequest.class, StanzaError.Type.MODIFY);
        ASSOCIATED_ERROR_TYPE.put(Conflict.class, StanzaError.Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(FeatureNotImplemented.class, StanzaError.Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(Forbidden.class, StanzaError.Type.AUTH);
        ASSOCIATED_ERROR_TYPE.put(Gone.class, StanzaError.Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(InternalServerError.class, StanzaError.Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(ItemNotFound.class, StanzaError.Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(JidMalformed.class, StanzaError.Type.MODIFY);
        ASSOCIATED_ERROR_TYPE.put(NotAcceptable.class, StanzaError.Type.MODIFY);
        ASSOCIATED_ERROR_TYPE.put(NotAllowed.class, StanzaError.Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(NotAuthorized.class, StanzaError.Type.AUTH);
        ASSOCIATED_ERROR_TYPE.put(PolicyViolation.class, StanzaError.Type.MODIFY);
        ASSOCIATED_ERROR_TYPE.put(RecipientUnavailable.class, StanzaError.Type.WAIT);
        ASSOCIATED_ERROR_TYPE.put(Redirect.class, StanzaError.Type.MODIFY);
        ASSOCIATED_ERROR_TYPE.put(RegistrationRequired.class, StanzaError.Type.AUTH);
        ASSOCIATED_ERROR_TYPE.put(RemoteServerNotFound.class, StanzaError.Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(RemoteServerTimeout.class, StanzaError.Type.WAIT);
        ASSOCIATED_ERROR_TYPE.put(ResourceConstraint.class, StanzaError.Type.WAIT);
        ASSOCIATED_ERROR_TYPE.put(ServiceUnavailable.class, StanzaError.Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(SubscriptionRequired.class, StanzaError.Type.AUTH);
        ASSOCIATED_ERROR_TYPE.put(UndefinedCondition.class, StanzaError.Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(UnexpectedRequest.class, StanzaError.Type.WAIT);
    }
}

