/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream.model;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.stream.model.ServerStreamElement;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.core.stream.model.errors.Text;

@XmlRootElement(name="error")
public final class StreamError
implements ServerStreamElement {
    @XmlElementRef
    private final Condition condition;
    @XmlElementRef
    private final Text text;
    @XmlAnyElement(lax=true)
    private final Object extension;

    private StreamError() {
        this.condition = null;
        this.text = null;
        this.extension = null;
    }

    public StreamError(Condition condition) {
        this(condition, null, null);
    }

    public StreamError(Condition condition, Text text, Object extension) {
        this.condition = Objects.requireNonNull(condition);
        this.text = text;
        this.extension = extension;
    }

    public final String getLanguage() {
        if (this.text != null) {
            return this.text.getLanguage();
        }
        return null;
    }

    public final String getText() {
        if (this.text != null) {
            return this.text.getText();
        }
        return null;
    }

    public final Object getExtension() {
        return this.extension;
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCondition().toString());
        if (this.getText() != null) {
            sb.append("\n        ");
            sb.append(this.getText());
        }
        if (this.getExtension() != null) {
            sb.append("\n        ");
            sb.append(this.getExtension().toString());
        }
        return sb.toString();
    }
}

