/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.data.layout.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.extensions.data.layout.model.FieldReference;
import rocks.xmpp.extensions.data.layout.model.Section;

@XmlRootElement(name="page")
public final class Page {
    public static final String NAMESPACE = "http://jabber.org/protocol/xdata-layout";
    @XmlElement(name="text")
    private final List<String> text = new ArrayList<String>();
    @XmlElement(name="fieldref")
    private final List<FieldReference> fieldReferences = new ArrayList<FieldReference>();
    @XmlElement(name="section")
    private final List<Section> sections = new ArrayList<Section>();
    @XmlAttribute(name="label")
    private final String label;
    @XmlElement(name="reportedref")
    private final FieldReference reportedReference;

    private Page() {
        this.label = null;
        this.reportedReference = null;
    }

    public Page(String label, Collection<FieldReference> fieldReferences) {
        this(label, fieldReferences, null);
    }

    public Page(String label, Collection<FieldReference> fieldReferences, Collection<String> text) {
        this(label, fieldReferences, text, null);
    }

    public Page(String label, Collection<FieldReference> fieldReferences, Collection<String> text, FieldReference reportedReference) {
        this.label = label;
        if (text != null) {
            this.text.addAll(text);
        }
        if (fieldReferences != null) {
            this.fieldReferences.addAll(fieldReferences);
        }
        this.reportedReference = reportedReference;
    }

    public final List<String> getText() {
        return Collections.unmodifiableList(this.text);
    }

    public final List<FieldReference> getFieldReferences() {
        return Collections.unmodifiableList(this.fieldReferences);
    }

    public final List<Section> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    public final FieldReference getReportedReference() {
        return this.reportedReference;
    }

    public final String getLabel() {
        return this.label;
    }
}

