/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.data.layout.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import rocks.xmpp.extensions.data.layout.model.FieldReference;

public final class Section {
    @XmlElement(name="section")
    private final List<Section> sections = new ArrayList<Section>();
    @XmlElement(name="text")
    private final List<String> text = new ArrayList<String>();
    @XmlElement(name="fieldref")
    private final List<FieldReference> fieldReferences = new ArrayList<FieldReference>();
    @XmlAttribute(name="label")
    private final String label;
    @XmlElement(name="reportedref")
    private final FieldReference reportedReference;

    private Section() {
        this.label = null;
        this.reportedReference = null;
    }

    public Section(String label, Collection<FieldReference> fieldReferences) {
        this(label, fieldReferences, null);
    }

    public Section(String label, Collection<FieldReference> fieldReferences, Collection<String> text) {
        this(label, fieldReferences, text, null);
    }

    public Section(String label, Collection<FieldReference> fieldReferences, Collection<String> text, FieldReference reportedReference) {
        this.label = label;
        if (text != null) {
            this.text.addAll(text);
        }
        if (fieldReferences != null) {
            this.fieldReferences.addAll(fieldReferences);
        }
        this.reportedReference = reportedReference;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getText() {
        return Collections.unmodifiableList(this.text);
    }

    public List<FieldReference> getFieldReferences() {
        return Collections.unmodifiableList(this.fieldReferences);
    }

    public List<Section> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    public FieldReference getReportedReference() {
        return this.reportedReference;
    }
}

