/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.data.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import rocks.xmpp.core.Jid;
import rocks.xmpp.extensions.data.layout.model.Page;
import rocks.xmpp.extensions.data.mediaelement.model.Media;
import rocks.xmpp.extensions.data.validate.model.Validation;

@XmlRootElement(name="x")
public final class DataForm
implements Comparable<DataForm> {
    public static final String NAMESPACE = "jabber:x:data";
    public static final String FORM_TYPE = "FORM_TYPE";
    @XmlElement
    private final List<String> instructions = new ArrayList<String>();
    @XmlElementRef
    private final List<Page> pages = new ArrayList<Page>();
    @XmlElement(name="field")
    private final List<Field> fields = new ArrayList<Field>();
    @XmlElement(name="item")
    private final List<Item> items = new ArrayList<Item>();
    @XmlAttribute
    private Type type;
    @XmlElement
    private String title;
    @XmlElementWrapper(name="reported")
    @XmlElement(name="field")
    private List<Field> reportedFields;

    private DataForm() {
    }

    public DataForm(Type type) {
        this.type = type;
    }

    public DataForm(Type type, Collection<Field> fields) {
        this.type = type;
        if (fields != null) {
            this.fields.addAll(fields);
        }
    }

    public DataForm(Builder<? extends Builder> builder) {
        if (((Builder)builder).formType != null) {
            this.fields.add(Field.builder().var(FORM_TYPE).value(((Builder)builder).formType).type(Field.Type.HIDDEN).build());
        }
        this.fields.addAll(((Builder)builder).fields);
        this.type = ((Builder)builder).type;
        this.title = ((Builder)builder).title;
        if (((Builder)builder).items != null) {
            this.items.addAll(((Builder)builder).items);
        }
        if (((Builder)builder).instructions != null) {
            this.instructions.addAll(((Builder)builder).instructions);
        }
        if (((Builder)builder).pages != null) {
            this.pages.addAll(this.pages);
        }
        if (((Builder)builder).reportedFields != null && !((Builder)builder).reportedFields.isEmpty()) {
            this.reportedFields = new ArrayList<Field>();
            this.reportedFields.addAll(((Builder)builder).reportedFields);
        }
    }

    @Deprecated
    public DataForm(Type type, String title) {
        this.type = type;
        this.title = title;
    }

    @Deprecated
    public DataForm(Type type, String title, String ... instructions) {
        this.type = type;
        this.title = title;
        this.instructions.addAll(Arrays.asList(instructions));
    }

    public DataForm(Type type, String title, Collection<Field> fields, Collection<Field> reportedFields, Collection<Item> items, Collection<String> instructions, Collection<Page> pages) {
        this.type = type;
        this.title = title;
        if (instructions != null) {
            this.instructions.addAll(instructions);
        }
        if (pages != null) {
            this.pages.addAll(pages);
        }
        if (fields != null) {
            this.fields.addAll(fields);
        }
        if (items != null) {
            this.items.addAll(items);
        }
        if (reportedFields != null && !reportedFields.isEmpty()) {
            this.reportedFields = new ArrayList<Field>();
            this.reportedFields.addAll(reportedFields);
        }
    }

    public static boolean parseBoolean(String value) {
        return Boolean.parseBoolean(value) || "1".equals(value);
    }

    public String findValue(String var) {
        List<String> values = this.findValues(var);
        return values.isEmpty() ? null : values.get(0);
    }

    public List<String> findValues(String var) {
        Field field = this.findField(var);
        return field == null ? Collections.emptyList() : field.getValues();
    }

    public boolean findValueAsBoolean(String var) {
        return DataForm.parseBoolean(this.findValue(var));
    }

    public Integer findValueAsInteger(String var) {
        Field field = this.findField(var);
        return field == null ? null : field.getValueAsInteger();
    }

    public Date findValueAsDate(String var) {
        Field field = this.findField(var);
        return field == null ? null : field.getValueAsDate();
    }

    public Jid findValueAsJid(String var) {
        Field field = this.findField(var);
        return field == null ? null : field.getValueAsJid();
    }

    public List<Jid> findValuesAsJid(String var) {
        Field field = this.findField(var);
        return field == null ? Collections.emptyList() : field.getValuesAsJid();
    }

    public String getFormType() {
        for (Field field : this.getFields()) {
            if (!FORM_TYPE.equals(field.getVar()) || field.getValues().isEmpty()) continue;
            return field.getValues().get(0);
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    @Deprecated
    public void setTitle(String title) {
        this.title = title;
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List<String> getInstructions() {
        return Collections.unmodifiableList(this.instructions);
    }

    public Type getType() {
        return this.type;
    }

    @Deprecated
    public void setType(Type type) {
        this.type = type;
    }

    public List<Field> getReportedFields() {
        return Collections.unmodifiableList(this.reportedFields);
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public List<Page> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    public Field findField(String name) {
        if (name != null) {
            for (Field field : this.fields) {
                if (!name.equals(field.getVar())) continue;
                return field;
            }
        }
        return null;
    }

    @Override
    public int compareTo(DataForm o) {
        String fto;
        String ft = this.getFormType();
        String string = fto = o != null ? o.getFormType() : null;
        if (ft == null && fto == null) {
            return 0;
        }
        if (ft == null) {
            return 1;
        }
        if (fto == null) {
            return -1;
        }
        return ft.compareTo(fto);
    }

    public static abstract class Builder<T extends Builder<T>> {
        private Collection<Field> fields;
        private Collection<Item> items;
        private String formType;
        private Type type;
        private String title;
        private Collection<String> instructions;
        private Collection<Page> pages;
        private Collection<Field> reportedFields;

        public final T fields(Collection<Field> fields) {
            this.fields = fields;
            return this.self();
        }

        public final T formType(String formType) {
            this.formType = formType;
            return this.self();
        }

        public final T type(Type type) {
            this.type = type;
            return this.self();
        }

        public final T title(String title) {
            this.title = title;
            return this.self();
        }

        public final T instructions(Collection<String> instructions) {
            this.instructions = instructions;
            return this.self();
        }

        public final T pages(Collection<Page> pages) {
            this.pages = pages;
            return this.self();
        }

        public final T items(Collection<Item> items) {
            this.items = items;
            return this.self();
        }

        public final T reportedFields(Collection<Field> reportedFields) {
            this.reportedFields = reportedFields;
            return this.self();
        }

        protected abstract T self();
    }

    public static final class Option {
        @XmlAttribute(name="label")
        private String label;
        @XmlElement(name="value")
        private String value;

        private Option() {
        }

        public Option(String value) {
            this.value = value;
        }

        public Option(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static final class Item {
        @XmlElement(name="field")
        private final List<Field> fields = new ArrayList<Field>();

        public List<Field> getFields() {
            return this.fields;
        }
    }

    @XmlRootElement(name="field")
    public static final class Field
    implements Comparable<Field> {
        @XmlElement(name="desc")
        private String description;
        @XmlElement(name="required")
        private String required;
        @XmlElementRef
        private Validation validation;
        @XmlElement(name="value")
        private List<String> values = new ArrayList<String>();
        @XmlElement(name="option")
        private List<Option> options = new ArrayList<Option>();
        @XmlElementRef
        private Media media;
        @XmlAttribute(name="label")
        private String label;
        @XmlAttribute(name="type")
        private Type type;
        @XmlAttribute(name="var")
        private String var;

        private Field() {
        }

        private Field(Builder builder) {
            this.type = builder.type;
            this.description = builder.description;
            this.required = builder.required ? "" : null;
            this.validation = builder.validation;
            this.values.addAll(builder.values);
            this.options.addAll(builder.options);
            this.media = builder.media;
            this.label = builder.label;
            this.var = builder.var;
        }

        @Deprecated
        public Field(Type type) {
            this.type = type;
        }

        public Field(Type type, String var, String ... values) {
            this.type = type;
            this.var = var;
            this.values.addAll(Arrays.asList(values));
        }

        public static Builder builder() {
            return new Builder();
        }

        public Type getType() {
            return this.type;
        }

        @Deprecated
        public void setType(Type type) {
            this.type = type;
        }

        public String getVar() {
            return this.var;
        }

        @Deprecated
        public void setVar(String var) {
            this.var = var;
        }

        public String getLabel() {
            return this.label;
        }

        @Deprecated
        public void setLabel(String label) {
            this.label = label;
        }

        public List<Option> getOptions() {
            return Collections.unmodifiableList(this.options);
        }

        public List<String> getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public boolean getValueAsBoolean() {
            return DataForm.parseBoolean(this.values.isEmpty() ? null : this.values.get(0));
        }

        public Integer getValueAsInteger() {
            return this.values.isEmpty() ? null : Integer.valueOf(this.values.get(0));
        }

        public Date getValueAsDate() {
            if (this.values.isEmpty()) {
                return null;
            }
            return this.values.get(0) != null ? DatatypeConverter.parseDateTime((String)this.values.get(0)).getTime() : null;
        }

        public List<Jid> getValuesAsJid() {
            ArrayList<Jid> jids = new ArrayList<Jid>();
            for (String value : this.values) {
                jids.add(Jid.valueOf(value, true));
            }
            return Collections.unmodifiableList(jids);
        }

        public Jid getValueAsJid() {
            return this.values.isEmpty() ? null : Jid.valueOf(this.values.get(0));
        }

        public Media getMedia() {
            return this.media;
        }

        @Deprecated
        public void setMedia(Media media) {
            this.media = media;
        }

        public String getDescription() {
            return this.description;
        }

        @Deprecated
        public void setDescription(String description) {
            this.description = description;
        }

        public Validation getValidation() {
            return this.validation;
        }

        @Deprecated
        public void setValidation(Validation validation) {
            this.validation = validation;
        }

        public boolean isRequired() {
            return this.required != null;
        }

        @Deprecated
        public void setRequired(boolean required) {
            this.required = required ? "" : null;
        }

        @Override
        public int compareTo(Field o) {
            if (DataForm.FORM_TYPE.equals(this.getVar()) && !DataForm.FORM_TYPE.equals(o.getVar())) {
                return -1;
            }
            if (this.getVar() == null && o.getVar() == null) {
                return 0;
            }
            if (this.getVar() == null) {
                return -1;
            }
            if (o.getVar() == null) {
                return 1;
            }
            return this.getVar().compareTo(o.getVar());
        }

        public static final class Builder {
            private final List<String> values = new ArrayList<String>();
            private final List<Option> options = new ArrayList<Option>();
            private Type type;
            private String description;
            private boolean required;
            private Media media;
            private Validation validation;
            private String var;
            private String label;

            private Builder() {
            }

            public Builder type(Type type) {
                this.type = type;
                return this;
            }

            public Builder required(boolean required) {
                this.required = required;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder media(Media media) {
                this.media = media;
                return this;
            }

            public Builder validation(Validation validation) {
                this.validation = validation;
                return this;
            }

            public Builder label(String label) {
                this.label = label;
                return this;
            }

            public Builder var(String var) {
                this.var = var;
                return this;
            }

            public Builder value(String value) {
                this.values.clear();
                this.values.add(value);
                return this.type(Type.TEXT_SINGLE);
            }

            public Builder value(boolean value) {
                this.value(value ? "1" : "0");
                return this.type(Type.BOOLEAN);
            }

            public Builder value(int value) {
                this.value(String.valueOf(value));
                return this.type(Type.TEXT_SINGLE);
            }

            public Builder value(Jid value) {
                if (value != null) {
                    this.value(value.toEscapedString());
                }
                return this.type(Type.JID_SINGLE);
            }

            public Builder value(Date date) {
                if (date != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    this.value(DatatypeConverter.printDateTime((Calendar)calendar));
                }
                return this.type(Type.TEXT_SINGLE);
            }

            public Builder values(Collection<String> values) {
                this.values.clear();
                if (values != null) {
                    this.values.addAll(values);
                }
                return this.type(Type.TEXT_MULTI);
            }

            public Builder valuesEnum(Collection<? extends Enum<?>> values) {
                this.values.clear();
                for (Enum<?> enumValue : values) {
                    this.values.add(enumValue.name().toLowerCase());
                }
                return this.type(Type.LIST_SINGLE);
            }

            public Builder valuesJid(Collection<Jid> values) {
                this.values.clear();
                if (values != null) {
                    for (Jid value : values) {
                        this.values.add(value.toEscapedString());
                    }
                }
                return this.type(Type.JID_MULTI);
            }

            public Builder options(Collection<Option> options) {
                this.options.clear();
                this.options.addAll(options);
                return this;
            }

            public Field build() {
                return new Field(this);
            }
        }

        @XmlType(name="field-type")
        public static enum Type {
            BOOLEAN,
            FIXED,
            HIDDEN,
            JID_MULTI,
            JID_SINGLE,
            LIST_MULTI,
            LIST_SINGLE,
            TEXT_MULTI,
            TEXT_PRIVATE,
            TEXT_SINGLE;

        }
    }

    @XmlEnum
    @XmlType(name="form-type")
    public static enum Type {
        CANCEL,
        FORM,
        RESULT,
        SUBMIT;

    }
}

