/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.roster.model;

import java.util.Arrays;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.roster.model.Contact;
import rocks.xmpp.core.roster.model.Roster;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;

public class RosterTest
extends XmlTest {
    protected RosterTest() throws JAXBException, XMLStreamException {
        super(IQ.class, Roster.class);
    }

    @Test
    public void testPlainRoster() throws XMLStreamException, JAXBException {
        String xml = "<iq from='juliet@example.com/balcony'\n       id='hu2bac18'\n       type='get'>\n     <query xmlns='jabber:iq:roster'/>\n   </iq>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertNotNull((Object)iq);
    }

    @Test
    public void testUnmarshalRoster() throws XMLStreamException, JAXBException {
        String xml = "<iq id='hu2bac18'\n       to='juliet@example.com/balcony'\n       type='result'>\n     <query xmlns='jabber:iq:roster' ver='ver11'>\n       <item jid='romeo@example.net'\n             name='Romeo'\n             subscription='both'>\n         <group>Friends</group>\n       </item>\n       <item jid='mercutio@example.com'\n             name='Mercutio'\n             subscription='from'/>\n       <item jid='benvolio@example.net'\n             name='Benvolio'\n             subscription='both'/>\n       <item jid='none@example.net'\n             name='None'\n             subscription='none'/>\n       <item jid='To@example.net'\n             name='To'\n             subscription='to'/>\n     </query>\n   </iq>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertEquals((Object)iq.getType(), (Object)AbstractIQ.Type.RESULT);
        Assert.assertNotNull((Object)iq);
        Roster roster = (Roster)iq.getExtension(Roster.class);
        Assert.assertNotNull((Object)roster);
        Assert.assertEquals((int)roster.getContacts().size(), (int)5);
        Assert.assertEquals((String)((Contact)roster.getContacts().get(0)).getJid().toString(), (String)"romeo@example.net");
        Assert.assertEquals((int)((Contact)roster.getContacts().get(0)).getGroups().size(), (int)1);
        Assert.assertEquals((String)((String)((Contact)roster.getContacts().get(0)).getGroups().get(0)), (String)"Friends");
        Assert.assertEquals((String)((Contact)roster.getContacts().get(1)).getName(), (String)"Mercutio");
        Assert.assertEquals((Object)((Contact)roster.getContacts().get(2)).getSubscription(), (Object)Contact.Subscription.BOTH);
        Assert.assertEquals((Object)((Contact)roster.getContacts().get(3)).getSubscription(), (Object)Contact.Subscription.NONE);
        Assert.assertEquals((Object)((Contact)roster.getContacts().get(4)).getSubscription(), (Object)Contact.Subscription.TO);
        Assert.assertEquals((String)roster.getVersion(), (String)"ver11");
    }

    @Test
    public void testUnmarshalRemoveRosterItem() throws XMLStreamException, JAXBException {
        String xml = "<iq from='juliet@example.com/balcony'\n       id='hm4hs97y'\n       type='set'>\n     <query xmlns='jabber:iq:roster'>\n       <item jid='nurse@example.com'\n             subscription='remove'/>\n     </query>\n   </iq>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertNotNull((Object)iq);
        Roster roster = (Roster)iq.getExtension(Roster.class);
        Assert.assertNotNull((Object)roster);
        Assert.assertEquals((Object)((Contact)roster.getContacts().get(0)).getSubscription(), (Object)Contact.Subscription.REMOVE);
        Assert.assertFalse((boolean)((Contact)roster.getContacts().get(0)).isPending());
        Assert.assertFalse((boolean)((Contact)roster.getContacts().get(0)).isApproved());
    }

    @Test
    public void testUnmarshalPendingItem() throws XMLStreamException, JAXBException {
        String xml = "<iq id='b89c5r7ib575'\n        to='romeo@example.net/bar'\n        type='set'>\n      <query xmlns='jabber:iq:roster'>\n        <item ask='subscribe'\n              jid='juliet@example.com'\n              subscription='none'/>\n      </query>\n    </iq>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertNotNull((Object)iq);
        Roster roster = (Roster)iq.getExtension(Roster.class);
        Assert.assertNotNull((Object)roster);
        Assert.assertTrue((boolean)((Contact)roster.getContacts().get(0)).isPending());
    }

    @Test
    public void testUnmarshalApprovedRostertem() throws XMLStreamException, JAXBException {
        String xml = "<iq id='b89c5r7ib575'\n        to='romeo@example.net/bar'\n        type='set'>\n      <query xmlns='jabber:iq:roster'>\n        <item approved='true'\n              jid='juliet@example.com'\n              subscription='none'/>\n      </query>\n    </iq>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertNotNull((Object)iq);
        Roster roster = (Roster)iq.getExtension(Roster.class);
        Assert.assertNotNull((Object)roster);
        Assert.assertTrue((boolean)((Contact)roster.getContacts().get(0)).isApproved());
    }

    @Test
    public void testMarshalRoster() throws XMLStreamException, JAXBException {
        String xml = "<query xmlns=\"jabber:iq:roster\"><item jid=\"node1@domain\"></item><item jid=\"node2@domain\" name=\"Name\"><group>Group1</group><group>Group2</group></item></query>";
        Roster roster = new Roster(Arrays.asList(new Contact(Jid.valueOf((String)"node1@domain")), new Contact(Jid.valueOf((String)"node2@domain"), "Name", Boolean.valueOf(false), null, null, Arrays.asList("Group1", "Group2"))));
        String rosterXml = this.marshal(roster);
        Assert.assertEquals((String)rosterXml, (String)xml);
    }

    @Test
    public void testContactEquality() throws XMLStreamException, JAXBException {
        Contact contact1 = new Contact(Jid.valueOf((String)"node1@domain"), "name", Boolean.valueOf(false), null, Contact.Subscription.FROM, Arrays.asList("group2", "group1"));
        Contact contact2 = new Contact(Jid.valueOf((String)"node1@domain"), "name", Boolean.valueOf(false), null, Contact.Subscription.FROM, Arrays.asList("group1", "group2"));
        Assert.assertEquals((Object)contact1, (Object)contact2);
    }
}

