/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.sasl;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.sasl.model.Abort;
import rocks.xmpp.core.sasl.model.Auth;
import rocks.xmpp.core.sasl.model.Challenge;
import rocks.xmpp.core.sasl.model.Failure;
import rocks.xmpp.core.sasl.model.Response;
import rocks.xmpp.core.sasl.model.Success;

public class SaslTest
extends XmlTest {
    protected SaslTest() throws JAXBException, XMLStreamException {
        super(Auth.class, Challenge.class, Response.class, Success.class, Abort.class, Failure.class);
    }

    @Test
    public void unmarshalAuth() throws XMLStreamException, JAXBException {
        String xml = "<auth xmlns='urn:ietf:params:xml:ns:xmpp-sasl'/>";
        Auth auth = this.unmarshal(xml, Auth.class);
        Assert.assertNotNull((Object)auth);
    }

    @Test
    public void unmarshalChallenge() throws XMLStreamException, JAXBException {
        String xml = "<challenge xmlns='urn:ietf:params:xml:ns:xmpp-sasl'/>";
        Challenge challenge = this.unmarshal(xml, Challenge.class);
        Assert.assertNotNull((Object)challenge);
    }

    @Test
    public void unmarshalResponse() throws XMLStreamException, JAXBException {
        String xml = "<response xmlns='urn:ietf:params:xml:ns:xmpp-sasl'/>";
        Response response = this.unmarshal(xml, Response.class);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void unmarshalAbort() throws XMLStreamException, JAXBException {
        String xml = "<abort xmlns='urn:ietf:params:xml:ns:xmpp-sasl'/>";
        Abort abort = this.unmarshal(xml, Abort.class);
        Assert.assertNotNull((Object)abort);
    }

    @Test
    public void unmarshalSuccess() throws XMLStreamException, JAXBException {
        String xml = "<success xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>base64</success>";
        Success success = this.unmarshal(xml, Success.class);
        Assert.assertNotNull((Object)success);
        Assert.assertNotNull((Object)success.getAdditionalData());
    }

    @Test
    public void unmarshalAccountDisabled() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>\n     <account-disabled/>\n     <text xml:lang='en'>Call 212-555-1212 for assistance.</text>\n   </failure>";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == Failure.Condition.ACCOUNT_DISABLED ? 1 : 0) != 0);
        Assert.assertEquals((String)failure.getLanguage(), (String)"en");
        Assert.assertEquals((String)failure.getText(), (String)"Call 212-555-1212 for assistance.");
    }

    @Test
    public void unmarshalCredentialsExpired() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>\n     <credentials-expired/>\n   </failure>";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == Failure.Condition.CREDENTIALS_EXPIRED ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalEncryptionRequired() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>\n     <encryption-required/>\n   </failure>";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == Failure.Condition.ENCRYPTION_REQUIRED ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalIncorrectEncoding() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>\n     <incorrect-encoding/>\n   </failure>";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == Failure.Condition.INCORRECT_ENCODING ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalInvalidAuthzid() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>\n     <invalid-authzid/>\n   </failure>";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == Failure.Condition.INVALID_AUTHZID ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalMalformedRequest() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>\n     <malformed-request/>\n   </failure>";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == Failure.Condition.MALFORMED_REQUEST ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalMechanismTooWeak() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>\n     <mechanism-too-weak/>\n   </failure>";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == Failure.Condition.MECHANISM_TOO_WEAK ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalInvalidMechanism() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>\n     <invalid-mechanism/>\n   </failure>";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == Failure.Condition.INVALID_MECHANISM ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalNotAuthorized() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>\n     <not-authorized/>\n   </failure>";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == Failure.Condition.NOT_AUTHORIZED ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalTemporaryAuthFailure() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>\n     <temporary-auth-failure/>\n   </failure>";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == Failure.Condition.TEMPORARY_AUTH_FAILURE ? 1 : 0) != 0);
    }
}

