/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.core.stream.model.errors.SeeOtherHost;

public class StreamErrorTest
extends XmlTest {
    protected StreamErrorTest() throws JAXBException, XMLStreamException {
        super(StreamError.class);
    }

    @Test
    public void unmarshalBadFormat() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <bad-format\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.BAD_FORMAT ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalBadNamespacePrefix() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <bad-namespace-prefix\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.BAD_NAMESPACE_PREFIX ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalConflict() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <conflict\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.CONFLICT ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalConnectionTimeout() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <connection-timeout\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.CONNECTION_TIMEOUT ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalHostGone() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <host-gone\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.HOST_GONE ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalHostUnknown() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <host-unknown\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.HOST_UNKNOWN ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalImproperAddressing() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <improper-addressing\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.IMPROPER_ADDRESSING ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalInternalServerError() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <internal-server-error\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.INTERNAL_SERVER_ERROR ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalInvalidFrom() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <invalid-from\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.INVALID_FROM ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalInvalidNamespace() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <invalid-namespace\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.INVALID_NAMESPACE ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalInvalidXml() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <invalid-xml\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.INVALID_XML ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalNotAuthorized() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <not-authorized\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.NOT_AUTHORIZED ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalNotWellFormed() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <not-well-formed\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.NOT_WELL_FORMED ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalPolicyViolation() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <policy-violation\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.POLICY_VIOLATION ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalRemoteConnectionFailed() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <remote-connection-failed\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.REMOTE_CONNECTION_FAILED ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalReset() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <reset\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.RESET ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalResourceConstraint() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <resource-constraint\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.RESOURCE_CONSTRAINT ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalRestrictedXml() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <restricted-xml\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.RESTRICTED_XML ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalSeeOtherHost() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <see-other-host\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'>[2001:41D0:1:A49b::1]:9222</see-other-host>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof SeeOtherHost));
        Assert.assertEquals((String)((SeeOtherHost)streamError.getCondition()).getOtherHost(), (String)"[2001:41D0:1:A49b::1]:9222");
    }

    @Test
    public void unmarshalSystemShutdown() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <system-shutdown\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.SYSTEM_SHUTDOWN ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalUndefinedCondition() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <undefined-condition\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.UNDEFINED_CONDITION ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalUnsupportedEncoding() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <unsupported-encoding\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.UNSUPPORTED_ENCODING ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalUnsupportedFeature() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <unsupported-feature\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.UNSUPPORTED_FEATURE ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalUnsupportedStanzaType() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <unsupported-stanza-type\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.UNSUPPORTED_STANZA_TYPE ? 1 : 0) != 0);
    }

    @Test
    public void shouldUnmarshalUnsupportedVersion() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <unsupported-version\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((streamError.getCondition() == Condition.UNSUPPORTED_VERSION ? 1 : 0) != 0);
    }

    @Test
    public void shouldUnmarshalErrorWithText() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <host-unknown\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n     <text xmlns='urn:ietf:params:xml:ns:xmpp-streams'\n           xml:lang='en'>OPTIONAL descriptive text</text>   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertEquals((String)streamError.getText(), (String)"OPTIONAL descriptive text");
        Assert.assertEquals((String)streamError.getLanguage(), (String)"en");
        Assert.assertTrue((streamError.getCondition() == Condition.HOST_UNKNOWN ? 1 : 0) != 0);
    }
}

