/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.compress;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.extensions.compress.model.StreamCompression;
import rocks.xmpp.extensions.compress.model.feature.CompressionFeature;

public class CompressionTest
extends XmlTest {
    protected CompressionTest() throws JAXBException, XMLStreamException {
        super(StreamCompression.class);
    }

    @Test
    public void unmarshalCompression() throws XMLStreamException, JAXBException {
        String xml = "<compression xmlns='http://jabber.org/features/compress'>\n    <method>zlib</method>\n    <method>lzw</method>\n  </compression>\n";
        CompressionFeature compressionFeature = this.unmarshal(xml, CompressionFeature.class);
        Assert.assertNotNull((Object)compressionFeature);
        Assert.assertEquals((int)compressionFeature.getMethods().size(), (int)2);
        Assert.assertEquals((String)((String)compressionFeature.getMethods().get(0)), (String)"zlib");
        Assert.assertEquals((String)((String)compressionFeature.getMethods().get(1)), (String)"lzw");
    }

    @Test
    public void unmarshalCompressed() throws XMLStreamException, JAXBException {
        String xml = "<compressed xmlns='http://jabber.org/protocol/compress'/>\n";
        Object compressed = this.unmarshal(xml);
        Assert.assertTrue((compressed == StreamCompression.COMPRESSED ? 1 : 0) != 0);
    }

    @Test
    public void marshalCompress() throws JAXBException, XMLStreamException {
        StreamCompression.Compress compress = new StreamCompression.Compress("zlib");
        String xml = this.marshal(compress);
        Assert.assertEquals((String)xml, (String)"<compress xmlns=\"http://jabber.org/protocol/compress\"><method>zlib</method></compress>");
    }

    @Test
    public void unmarshalFailureUnsupportedMethod() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='http://jabber.org/protocol/compress'>\n  <unsupported-method/>\n</failure>\n";
        StreamCompression.Failure failure = this.unmarshal(xml, StreamCompression.Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == StreamCompression.Failure.Condition.UNSUPPORTED_METHOD ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalFailureSetupFailed() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='http://jabber.org/protocol/compress'>\n  <setup-failed/>\n</failure>\n";
        StreamCompression.Failure failure = this.unmarshal(xml, StreamCompression.Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == StreamCompression.Failure.Condition.SETUP_FAILED ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalFailureProcessingFailed() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='http://jabber.org/protocol/compress'>\n  <processing-failed/>\n</failure>\n";
        StreamCompression.Failure failure = this.unmarshal(xml, StreamCompression.Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure.getCondition() == StreamCompression.Failure.Condition.PROCESSING_FAILED ? 1 : 0) != 0);
    }
}

