/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privatedata.rosterdelimiter;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.privatedata.model.PrivateData;
import rocks.xmpp.extensions.privatedata.rosterdelimiter.model.RosterDelimiter;

public class RosterDelimiterTest
extends XmlTest {
    protected RosterDelimiterTest() throws JAXBException, XMLStreamException {
        super(IQ.class, PrivateData.class, RosterDelimiter.class);
    }

    @Test
    public void unmarshalAnnotations() throws XMLStreamException, JAXBException {
        String xml = "<iq type='result'\n    id='1'\n    from='bill@shakespeare.lit/Globe'\n    to='bill@shakespeare.lit/Globe'>\n  <query xmlns='jabber:iq:private'>\n    <roster xmlns='roster:delimiter'>::</roster>\n  </query>\n</iq>\n";
        IQ iq = this.unmarshal(xml, IQ.class);
        PrivateData privateData = (PrivateData)iq.getExtension(PrivateData.class);
        Assert.assertNotNull((Object)privateData);
        Assert.assertTrue((boolean)(privateData.getData() instanceof RosterDelimiter));
        RosterDelimiter rosterDelimiter = (RosterDelimiter)privateData.getData();
        Assert.assertEquals((String)rosterDelimiter.getRosterDelimiter(), (String)"::");
    }

    @Test
    public void marshalRosterDelimiterQuery() throws JAXBException, XMLStreamException {
        IQ iq = new IQ(AbstractIQ.Type.GET, (Object)new PrivateData((Object)new RosterDelimiter()), "1");
        String xml = this.marshal(iq);
        Assert.assertEquals((String)xml, (String)"<iq id=\"1\" type=\"get\"><query xmlns=\"jabber:iq:private\"><roster xmlns=\"roster:delimiter\"></roster></query></iq>");
    }
}

