/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core;

import java.io.IOException;
import java.io.OutputStream;

final class BranchedOutputStream
extends OutputStream {
    private final OutputStream out;
    private final OutputStream branch;

    public BranchedOutputStream(OutputStream out, OutputStream branch) {
        this.out = out;
        this.branch = branch;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.branch.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.branch.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.branch.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        this.branch.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            this.branch.close();
        }
    }
}

