/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.StanzaError;

@XmlTransient
public abstract class AbstractPresence
extends Stanza
implements Comparable<AbstractPresence> {
    @XmlAnyElement(lax=true)
    private final List<Object> extensions = new CopyOnWriteArrayList<Object>();
    @XmlElement
    private final List<Status> status = new CopyOnWriteArrayList<Status>();
    @XmlElement
    private Byte priority;
    @XmlElement
    private Show show;
    @XmlAttribute
    private Type type;

    protected AbstractPresence() {
    }

    protected AbstractPresence(Jid to, Type type, Show show, Collection<Status> status, Byte priority, String id, Jid from, String language, Collection<?> extensions, StanzaError error) {
        super(to, from, id, language, error);
        this.show = show;
        this.type = type;
        this.show = show;
        if (status != null) {
            this.status.addAll(status);
        }
        this.priority = priority;
        if (extensions != null) {
            this.extensions.addAll(extensions);
        }
    }

    public final boolean isAvailable() {
        return this.type == null;
    }

    public final Show getShow() {
        return this.show;
    }

    @Deprecated
    public final void setShow(Show show) {
        this.show = show;
    }

    public final Byte getPriority() {
        return this.priority;
    }

    @Deprecated
    public final void setPriority(Byte priority) {
        this.priority = priority;
    }

    public final Type getType() {
        return this.type;
    }

    @Deprecated
    public final void setType(Type type) {
        this.type = type;
    }

    public final List<Status> getStatuses() {
        return Collections.unmodifiableList(this.status);
    }

    public final String getStatus() {
        for (Status status : this.status) {
            if (status.getLanguage() != null && !status.getLanguage().isEmpty()) continue;
            return status.getText();
        }
        if (!this.status.isEmpty()) {
            return this.status.get(0).getText();
        }
        return null;
    }

    @Deprecated
    public final void setStatus(String text) {
        if (text != null) {
            for (Status s : this.status) {
                if (s.getLanguage() != null && !s.getLanguage().isEmpty()) continue;
                s.setText(text);
                return;
            }
            this.status.add(new Status(text));
        } else {
            this.status.clear();
        }
    }

    public final List<Object> getExtensions() {
        return this.extensions;
    }

    @Override
    public final <T> T getExtension(Class<T> type) {
        for (Object extension : this.extensions) {
            if (!type.isAssignableFrom(extension.getClass())) continue;
            return (T)extension;
        }
        return null;
    }

    @Override
    public final int compareTo(AbstractPresence o) {
        if (o == null) {
            return -1;
        }
        if (this.isAvailable() && !o.isAvailable()) {
            return -1;
        }
        if (!this.isAvailable() && o.isAvailable()) {
            return 1;
        }
        int result = Byte.compare(this.priority != null ? this.priority : (byte)0, o.getPriority() != null ? o.getPriority() : (byte)0);
        if (result == 0) {
            if (this.getShow() == null && o.getShow() != null) {
                return -1;
            }
            if (this.getShow() == null) {
                return 0;
            }
            if (o.getShow() == null) {
                return 1;
            }
            return this.getShow().compareTo(o.getShow());
        }
        return result;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            String sType = this.type.name();
            sb.append(sType.substring(0, 1)).append(sType.substring(1).toLowerCase()).append(" ");
        }
        sb.append("Presence");
        if (this.show != null) {
            sb.append(" ").append(this.show.name());
        }
        sb.append(super.toString());
        String status = this.getStatus();
        if (status != null) {
            sb.append(": ").append(status);
        }
        return sb.toString();
    }

    public static final class Status {
        @XmlAttribute(name="lang", namespace="http://www.w3.org/XML/1998/namespace")
        private String language;
        @XmlValue
        private String text;

        private Status() {
        }

        public Status(String text) {
            this.text = text;
        }

        public Status(String text, String language) {
            this.text = text;
            this.language = language;
        }

        public String getLanguage() {
            return this.language;
        }

        @Deprecated
        public void setLanguage(String language) {
            this.language = language;
        }

        public String getText() {
            return this.text;
        }

        @Deprecated
        public void setText(String text) {
            this.text = text;
        }
    }

    @XmlType(name="presenceType")
    public static enum Type {
        ERROR,
        PROBE,
        SUBSCRIBE,
        SUBSCRIBED,
        UNAVAILABLE,
        UNSUBSCRIBE,
        UNSUBSCRIBED;

    }

    public static enum Show {
        CHAT,
        AWAY,
        XA,
        DND;

    }
}

