/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.compress.model;

import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.core.stream.model.ServerStreamElement;
import rocks.xmpp.extensions.compress.model.feature.CompressionFeature;

@XmlSeeAlso(value={CompressionFeature.class, Compress.class, Compressed.class, Failure.class})
public abstract class StreamCompression {
    public static final String NAMESPACE = "http://jabber.org/protocol/compress";
    public static final StreamCompression COMPRESSED = new Compressed();

    private StreamCompression() {
    }

    @XmlRootElement(name="compressed")
    @XmlType(factoryMethod="create")
    static final class Compressed
    extends StreamCompression
    implements ServerStreamElement {
        private Compressed() {
        }

        private static Compressed create() {
            return (Compressed)COMPRESSED;
        }
    }

    @XmlRootElement(name="compress")
    public static final class Compress
    implements ClientStreamElement {
        @XmlElement
        private final String method;

        private Compress() {
            this.method = null;
        }

        public Compress(String method) {
            this.method = Objects.requireNonNull(method);
        }

        public final String getMethod() {
            return this.method;
        }
    }

    @XmlRootElement(name="failure")
    public static final class Failure
    extends StreamCompression
    implements ServerStreamElement {
        @XmlElements(value={@XmlElement(name="setup-failed", type=SetupFailed.class), @XmlElement(name="processing-failed", type=ProcessingFailed.class), @XmlElement(name="unsupported-method", type=UnsupportedMethod.class)})
        private final Condition condition;

        private Failure() {
            this.condition = null;
        }

        public Failure(Condition condition) {
            this.condition = Objects.requireNonNull(condition);
        }

        public final Condition getCondition() {
            return this.condition;
        }

        @XmlType(factoryMethod="create")
        private static final class UnsupportedMethod
        extends Condition {
            private UnsupportedMethod() {
                super("unsupported-method");
            }

            private static UnsupportedMethod create() {
                return (UnsupportedMethod)UNSUPPORTED_METHOD;
            }
        }

        @XmlType(factoryMethod="create")
        private static final class ProcessingFailed
        extends Condition {
            private ProcessingFailed() {
                super("processing-failed");
            }

            private static ProcessingFailed create() {
                return (ProcessingFailed)PROCESSING_FAILED;
            }
        }

        @XmlType(factoryMethod="create")
        private static final class SetupFailed
        extends Condition {
            private SetupFailed() {
                super("setup-failed");
            }

            private static SetupFailed create() {
                return (SetupFailed)SETUP_FAILED;
            }
        }

        public static abstract class Condition {
            public static final Condition SETUP_FAILED = new SetupFailed();
            public static final Condition PROCESSING_FAILED = new ProcessingFailed();
            public static final Condition UNSUPPORTED_METHOD = new UnsupportedMethod();
            private final String name;

            private Condition(String name) {
                this.name = name;
            }

            public final String toString() {
                return this.name;
            }
        }
    }
}

