/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privatedata.rosternotes.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.core.Jid;

@XmlRootElement(name="storage")
public final class Annotation {
    public static final String NAMESPACE = "storage:rosternotes";
    @XmlElement(name="note")
    private final List<Note> notes = new ArrayList<Note>();

    private Annotation() {
    }

    public Annotation(Collection<Note> notes) {
        if (notes != null) {
            this.notes.addAll(notes);
        }
    }

    public final List<Note> getNotes() {
        return Collections.unmodifiableList(this.notes);
    }

    public static final class Note {
        @XmlAttribute(name="jid")
        private final Jid jid;
        @XmlAttribute(name="cdate")
        private final Date creationDate;
        @XmlAttribute(name="mdate")
        private final Date modificationDate;
        @XmlValue
        private final String value;

        private Note() {
            this.value = null;
            this.jid = null;
            this.creationDate = null;
            this.modificationDate = null;
        }

        public Note(String note, Jid jid) {
            this(note, jid, null, null);
        }

        public Note(String note, Jid jid, Date creationDate, Date modificationDate) {
            this.value = note;
            this.jid = Objects.requireNonNull(jid, "jid must not be null.").asBareJid();
            this.creationDate = creationDate;
            this.modificationDate = modificationDate;
        }

        public final String getValue() {
            return this.value;
        }

        public final Date getModificationDate() {
            return this.modificationDate;
        }

        public final Date getCreationDate() {
            return this.creationDate;
        }

        public final Jid getJid() {
            return this.jid;
        }

        public final String toString() {
            return this.value;
        }
    }
}

