/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core;

import java.io.StringWriter;
import java.util.ArrayDeque;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.sasl.model.Auth;
import rocks.xmpp.core.sasl.model.Response;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.client.ClientIQ;
import rocks.xmpp.extensions.httpbind.model.Body;
import rocks.xmpp.im.roster.model.Contact;
import rocks.xmpp.im.roster.model.Roster;
import rocks.xmpp.util.XmppUtils;

public class PrefixFreeCanonicalizationWriterTest {
    @Test
    public void testSimpleStanza() throws XMLStreamException, JAXBException {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(writer);
        XMLStreamWriter prefixFreeWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)xmlStreamWriter, (String)"jabber:client");
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ClientIQ.class, Roster.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)true);
        ArrayDeque<Contact> contacts = new ArrayDeque<Contact>();
        contacts.add(new Contact(Jid.ofDomain((String)"domain")));
        Roster roster = new Roster(contacts);
        ClientIQ iq = ClientIQ.from((IQ)new IQ(IQ.Type.GET, (Object)roster, "1"));
        marshaller.marshal((Object)iq, prefixFreeWriter);
        Assert.assertEquals((String)((Object)writer).toString(), (String)"<iq id=\"1\" type=\"get\"><query xmlns=\"jabber:iq:roster\"><item jid=\"domain\"></item></query></iq>");
    }

    @Test
    public void testElementWithPrefixedAttribute() throws XMLStreamException, JAXBException {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(writer);
        XMLStreamWriter xmppStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)xmlStreamWriter);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Body.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)true);
        Body body = Body.builder().xmppVersion("1.0").restart(true).requestId(1L).build();
        marshaller.marshal((Object)body, xmppStreamWriter);
        Assert.assertEquals((String)((Object)writer).toString(), (String)"<body xmlns=\"http://jabber.org/protocol/httpbind\" rid=\"1\" xmlns:xmpp=\"urn:xmpp:xbosh\" xmpp:version=\"1.0\" xmpp:restart=\"true\"></body>");
    }

    @Test
    public void testTwoElementsWithSameNamespace() throws XMLStreamException, JAXBException {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(writer);
        XMLStreamWriter xmppStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)xmlStreamWriter);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Auth.class, Response.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)true);
        Auth auth = new Auth("PLAIN", null);
        marshaller.marshal((Object)auth, xmppStreamWriter);
        Response response = new Response(null);
        marshaller.marshal((Object)response, xmppStreamWriter);
        Assert.assertEquals((String)((Object)writer).toString(), (String)"<auth xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\" mechanism=\"PLAIN\"></auth><response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\"></response>");
    }
}

