/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.ClientIQ;
import rocks.xmpp.core.stanza.model.errors.Condition;

public class IQTest
extends XmlTest {
    protected IQTest() throws JAXBException, XMLStreamException {
        super(ClientIQ.class);
    }

    @Test
    public void unmarshalIQ() throws JAXBException, XMLStreamException {
        String xml = "<iq from='juliet@example.com/balcony'\n       id='b4vs9km4'\n       to='romeo@example.net' type='error'/>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertEquals((Object)iq.getType(), (Object)IQ.Type.ERROR);
        Assert.assertEquals((String)iq.getId(), (String)"b4vs9km4");
        Assert.assertEquals((String)iq.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((String)iq.getFrom().toString(), (String)"juliet@example.com/balcony");
    }

    @Test
    public void unmarshalResultIQ() throws XMLStreamException, JAXBException {
        String xml = "<iq type=\"result\"/>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertEquals((Object)iq.getType(), (Object)IQ.Type.RESULT);
    }

    @Test
    public void unmarshalGetIQ() throws XMLStreamException, JAXBException {
        String xml = "<iq type=\"get\"/>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertEquals((Object)iq.getType(), (Object)IQ.Type.GET);
    }

    @Test
    public void unmarshalSetIQ() throws XMLStreamException, JAXBException {
        String xml = "<iq type=\"set\"/>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertEquals((Object)iq.getType(), (Object)IQ.Type.SET);
    }

    @Test
    public void unmarshalErrorIQ() throws XMLStreamException, JAXBException {
        String xml = "<iq type=\"error\"/>";
        IQ iq = this.unmarshal(xml, IQ.class);
        Assert.assertEquals((Object)iq.getType(), (Object)IQ.Type.ERROR);
    }

    @Test
    public void marshalIQ() throws JAXBException, XMLStreamException {
        IQ iq = new IQ(Jid.ofLocalAndDomain((String)"to", (String)"domain"), IQ.Type.GET, null, "id", Jid.ofLocalAndDomain((String)"from", (String)"domain"), null, null);
        String xml = this.marshal(iq);
        Assert.assertEquals((String)xml, (String)"<iq from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"get\"></iq>");
    }

    @Test
    public void marshalIQWithError() throws JAXBException, XMLStreamException {
        IQ iq = new IQ(Jid.ofLocalAndDomain((String)"to", (String)"domain"), IQ.Type.GET, null, "id", Jid.ofLocalAndDomain((String)"from", (String)"domain"), null, new StanzaError(StanzaError.Type.MODIFY, Condition.SERVICE_UNAVAILABLE));
        String xml = this.marshal(iq);
        Assert.assertEquals((String)xml, (String)"<iq from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"get\"><error type=\"modify\"><service-unavailable xmlns=\"urn:ietf:params:xml:ns:xmpp-stanzas\"></service-unavailable></error></iq>");
    }

    @Test
    public void testErrorIQ() throws JAXBException, XMLStreamException {
        IQ iq = new IQ(Jid.ofLocalAndDomain((String)"to", (String)"domain"), IQ.Type.GET, null, "id", Jid.ofLocalAndDomain((String)"from", (String)"domain"), null, null);
        IQ error = iq.createError(new StanzaError(Condition.UNDEFINED_CONDITION));
        IQ error2 = iq.createError(Condition.UNDEFINED_CONDITION);
        Assert.assertEquals((Object)error.getType(), (Object)IQ.Type.ERROR);
        Assert.assertEquals((String)error.getId(), (String)iq.getId());
        Assert.assertEquals((Object)error.getTo(), (Object)iq.getFrom());
        Assert.assertEquals((Object)error.getFrom(), (Object)iq.getTo());
        Assert.assertEquals((Object)error2.getType(), (Object)IQ.Type.ERROR);
        Assert.assertEquals((String)error2.getId(), (String)iq.getId());
        Assert.assertEquals((Object)error2.getTo(), (Object)iq.getFrom());
        Assert.assertEquals((Object)error2.getFrom(), (Object)iq.getTo());
        Assert.assertEquals((String)this.marshal(error2), (String)"<iq from=\"to@domain\" id=\"id\" to=\"from@domain\" type=\"error\"><error type=\"cancel\"><undefined-condition xmlns=\"urn:ietf:params:xml:ns:xmpp-stanzas\"></undefined-condition></error></iq>");
    }

    @Test
    public void testResultIQ() throws JAXBException, XMLStreamException {
        IQ iq = new IQ(Jid.ofLocalAndDomain((String)"to", (String)"domain"), IQ.Type.GET, null, "id", Jid.ofLocalAndDomain((String)"from", (String)"domain"), null, null);
        IQ result = iq.createResult();
        Assert.assertEquals((Object)result.getType(), (Object)IQ.Type.RESULT);
        Assert.assertEquals((String)result.getId(), (String)iq.getId());
        Assert.assertEquals((Object)result.getTo(), (Object)iq.getFrom());
        Assert.assertEquals((Object)result.getFrom(), (Object)iq.getTo());
    }
}

