/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Text;
import rocks.xmpp.core.stanza.model.client.ClientPresence;
import rocks.xmpp.core.stanza.model.errors.Condition;

public class PresenceTest
extends XmlTest {
    protected PresenceTest() throws JAXBException, XMLStreamException {
        super(ClientPresence.class);
    }

    @Test
    public void unmarshalPresence() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net'              id='xk3h1v69'\n              to='juliet@example.com'\n              type='subscribe'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"juliet@example.com");
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)Presence.Type.SUBSCRIBE);
        Assert.assertEquals((String)presence.getId(), (String)"xk3h1v69");
    }

    @Test
    public void unmarshalPresenceWithError() throws XMLStreamException, JAXBException {
        String xml = "<presence from='juliet@example.com'\n              id='xk3h1v69'\n              to='romeo@example.net'\n              type='error'>\n      <error type='modify'>\n        <remote-server-not-found\n            xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>\n      </error>\n    </presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"juliet@example.com");
        Assert.assertEquals((Object)presence.getType(), (Object)Presence.Type.ERROR);
        Assert.assertNotNull((Object)presence.getError());
        Assert.assertNotNull((Object)(presence.getError().getCondition() == Condition.REMOTE_SERVER_NOT_FOUND ? 1 : 0));
    }

    @Test
    public void unmarshalPresenceTypeSubscribed() throws XMLStreamException, JAXBException {
        String xml = "<presence from='juliet@example.com'\n              id='xk3h1v69'\n              to='romeo@example.net'\n              type='subscribed'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"juliet@example.com");
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)Presence.Type.SUBSCRIBED);
        Assert.assertEquals((String)presence.getId(), (String)"xk3h1v69");
    }

    @Test
    public void unmarshalPresenceTypeUnsubscribed() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='unsubscribed'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)Presence.Type.UNSUBSCRIBED);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceTypeUnsubscribe() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='unsubscribe'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)Presence.Type.UNSUBSCRIBE);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceTypeProbe() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='probe'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)Presence.Type.PROBE);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceTypeUnavailable() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='unavailable'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)Presence.Type.UNAVAILABLE);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceStatus() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>dnd</show>\n  <status>Wooing Juliet</status>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"romeo@example.net/orchard");
        Assert.assertEquals((Object)presence.getShow(), (Object)Presence.Show.DND);
        Assert.assertEquals((String)presence.getLanguage(), (String)"en");
        Assert.assertEquals((String)presence.getStatus(), (String)"Wooing Juliet");
    }

    @Test
    public void unmarshalMultiplePresenceStatus() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          id='jx62vs97'\n          xml:lang='en'>\n  <show>dnd</show>\n  <status>Wooing Juliet</status>\n  <status xml:lang='de'>Julia</status>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"romeo@example.net/orchard");
        Assert.assertEquals((Object)presence.getShow(), (Object)Presence.Show.DND);
        Assert.assertEquals((String)presence.getLanguage(), (String)"en");
        Assert.assertEquals((String)presence.getStatus(), (String)"Wooing Juliet");
    }

    @Test
    public void unmarshalPresenceShowAway() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>away</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)Presence.Show.AWAY);
    }

    @Test
    public void unmarshalPresenceShowXA() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>xa</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)Presence.Show.XA);
    }

    @Test
    public void unmarshalPresenceShowChat() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>chat</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)Presence.Show.CHAT);
    }

    @Test
    public void unmarshalPresenceShowDnd() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>dnd</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)Presence.Show.DND);
    }

    @Test
    public void unmarshalPriority() throws XMLStreamException, JAXBException {
        String xml = "<presence xml:lang='en'>\n  <show>dnd</show>\n  <status>Wooing Juliet</status>\n  <status xml:lang='cs'>Dvo&#x0159;&#x00ED;m se Julii</status>\n  <priority>1</priority>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getPriority(), (Object)1);
    }

    @Test
    public void marshalPresenceMultipleStatus() throws JAXBException, XMLStreamException {
        Presence presence = new Presence(Jid.ofLocalAndDomain((String)"to", (String)"domain"), Presence.Type.SUBSCRIBE, null, Arrays.asList(new Text("status", "de"), new Text("status2", "en")), null, "id", Jid.ofLocalAndDomain((String)"from", (String)"domain"), null, null, null);
        String xml = this.marshal(presence);
        Assert.assertEquals((String)xml, (String)"<presence from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"subscribe\"><status xml:lang=\"de\">status</status><status xml:lang=\"en\">status2</status></presence>");
    }

    @Test
    public void marshalPresenceShowDnd() throws JAXBException, XMLStreamException {
        Presence presence = new Presence(Jid.ofLocalAndDomain((String)"to", (String)"domain"), Presence.Type.SUBSCRIBED, Presence.Show.DND, Collections.emptyList(), null, "id", Jid.ofLocalAndDomain((String)"from", (String)"domain"), null, null, null);
        String xml = this.marshal(presence);
        Assert.assertEquals((String)xml, (String)"<presence from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"subscribed\"><show>dnd</show></presence>");
    }

    @Test
    public void marshalPresenceShowAway() throws JAXBException, XMLStreamException {
        Presence presence = new Presence(Jid.ofLocalAndDomain((String)"to", (String)"domain"), Presence.Type.UNSUBSCRIBE, Presence.Show.AWAY, Collections.emptyList(), null, "id", Jid.ofLocalAndDomain((String)"from", (String)"domain"), null, null, null);
        String xml = this.marshal(presence);
        Assert.assertEquals((String)xml, (String)"<presence from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"unsubscribe\"><show>away</show></presence>");
    }

    @Test
    public void marshalPresenceShowXA() throws JAXBException, XMLStreamException {
        Presence presence = new Presence(Jid.ofLocalAndDomain((String)"to", (String)"domain"), Presence.Type.UNSUBSCRIBED, Presence.Show.XA, Collections.emptyList(), null, "id", Jid.ofLocalAndDomain((String)"from", (String)"domain"), null, null, null);
        String xml = this.marshal(presence);
        Assert.assertEquals((String)xml, (String)"<presence from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"unsubscribed\"><show>xa</show></presence>");
    }

    @Test
    public void marshalPresenceShowChat() throws JAXBException, XMLStreamException {
        Presence presence = new Presence(Jid.ofLocalAndDomain((String)"to", (String)"domain"), Presence.Type.UNAVAILABLE, Presence.Show.CHAT, Collections.emptyList(), null, "id", Jid.ofLocalAndDomain((String)"from", (String)"domain"), null, null, null);
        String xml = this.marshal(presence);
        Assert.assertEquals((String)xml, (String)"<presence from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"unavailable\"><show>chat</show></presence>");
    }

    @Test
    public void testIsAvailable() throws JAXBException, XMLStreamException {
        Presence presence1 = new Presence();
        Assert.assertTrue((boolean)presence1.isAvailable());
        Presence presence2 = new Presence(Presence.Type.SUBSCRIBE);
        Assert.assertFalse((boolean)presence2.isAvailable());
        Presence presence3 = new Presence(Presence.Type.UNSUBSCRIBED);
        Assert.assertFalse((boolean)presence3.isAvailable());
        Presence presence4 = new Presence(Presence.Type.UNSUBSCRIBE);
        Assert.assertFalse((boolean)presence4.isAvailable());
        Presence presence5 = new Presence(Presence.Type.SUBSCRIBED);
        Assert.assertFalse((boolean)presence5.isAvailable());
        Presence presence6 = new Presence(Presence.Type.ERROR);
        Assert.assertFalse((boolean)presence6.isAvailable());
        Presence presence7 = new Presence(Presence.Type.PROBE);
        Assert.assertFalse((boolean)presence7.isAvailable());
        Presence presence8 = new Presence(Presence.Type.UNAVAILABLE);
        Assert.assertFalse((boolean)presence8.isAvailable());
    }

    @Test
    public void testComparableImplementation() {
        Presence presenceUnavailable = new Presence(Presence.Type.UNAVAILABLE);
        Presence presenceDnd = new Presence(Presence.Show.DND, Byte.valueOf((byte)1));
        Presence presenceAway = new Presence(Presence.Show.AWAY, Byte.valueOf((byte)1));
        Presence presenceXa = new Presence(Presence.Show.XA, Byte.valueOf((byte)1));
        Presence presenceChat = new Presence(Presence.Show.CHAT, Byte.valueOf((byte)1));
        Presence presencePrio1 = new Presence(Byte.valueOf((byte)1));
        Presence presencePrio2 = new Presence(Byte.valueOf((byte)2));
        Presence presencePrio1Unavailble = new Presence(Presence.Type.UNAVAILABLE, Byte.valueOf((byte)1));
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(presenceAway);
        list.add(presenceDnd);
        list.add(presenceChat);
        list.add(presenceXa);
        list.add(presenceUnavailable);
        list.add(presencePrio1);
        list.add(presencePrio2);
        list.add(presencePrio1Unavailble);
        Collections.shuffle(list);
        list.sort(null);
        Assert.assertEquals(list.get(0), (Object)presencePrio1);
        Assert.assertEquals(list.get(1), (Object)presenceChat);
        Assert.assertEquals(list.get(2), (Object)presenceAway);
        Assert.assertEquals(list.get(3), (Object)presenceXa);
        Assert.assertEquals(list.get(4), (Object)presenceDnd);
        Assert.assertEquals(list.get(5), (Object)presencePrio2);
        Assert.assertEquals(list.get(6), (Object)presenceUnavailable);
        Assert.assertEquals(list.get(7), (Object)presencePrio1Unavailble);
    }
}

