/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.tls;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.tls.model.Failure;
import rocks.xmpp.core.tls.model.Proceed;
import rocks.xmpp.core.tls.model.StartTls;

public class TlsTest
extends XmlTest {
    protected TlsTest() throws JAXBException, XMLStreamException {
        super(StartTls.class, Proceed.class, Failure.class);
    }

    @Test
    public void unmarshalStartTls() throws XMLStreamException, JAXBException {
        String xml = "<starttls xmlns='urn:ietf:params:xml:ns:xmpp-tls'/>";
        StartTls startTls = this.unmarshal(xml, StartTls.class);
        Assert.assertNotNull((Object)startTls);
    }

    @Test
    public void unmarshalProceed() throws XMLStreamException, JAXBException {
        String xml = "<proceed xmlns='urn:ietf:params:xml:ns:xmpp-tls'/>";
        Proceed proceed = this.unmarshal(xml, Proceed.class);
        Proceed proceed1 = this.unmarshal(xml, Proceed.class);
        Assert.assertNotNull((Object)proceed);
        Assert.assertTrue((proceed == proceed1 ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalFailure() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-tls'/>";
        Failure failure = this.unmarshal(xml, Failure.class);
        Failure failure1 = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((failure == failure1 ? 1 : 0) != 0);
    }

    @Test
    public void marshalStartTls() throws JAXBException, XMLStreamException {
        String xml = this.marshal(new StartTls());
        Assert.assertEquals((String)xml, (String)"<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"></starttls>");
    }

    public void unmarshalPerformanceTest() throws JAXBException, XMLStreamException {
        String xml = "<failure xmlns='urn:ietf:params:xml:ns:xmpp-tls'/>";
        long now = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            Failure failure = this.unmarshal(xml, Failure.class);
            boolean bl = failure == Failure.INSTANCE;
        }
        System.out.println(System.currentTimeMillis() - now);
    }
}

