/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.extensions.caps.model.EntityCapabilities;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoNode;

public class EntityCapabilitiesManagerTest
extends XmlTest {
    protected EntityCapabilitiesManagerTest() throws JAXBException, XMLStreamException {
        super(EntityCapabilities.class);
    }

    @Test
    public void unmarshalCaps() throws JAXBException, XMLStreamException {
        String xml = "<c xmlns='http://jabber.org/protocol/caps' \n     hash='sha-1'\n     node='http://code.google.com/p/exodus'\n     ver='QgayPKawpkPSDYmwT/WM94uAlu0='/>\n";
        EntityCapabilities entityCapabilities = this.unmarshal(xml, EntityCapabilities.class);
        Assert.assertNotNull((Object)entityCapabilities);
        Assert.assertEquals((String)entityCapabilities.getHashingAlgorithm(), (String)"sha-1");
        Assert.assertEquals((String)entityCapabilities.getNode(), (String)"http://code.google.com/p/exodus");
        Assert.assertEquals((String)entityCapabilities.getVerificationString(), (String)"QgayPKawpkPSDYmwT/WM94uAlu0=");
    }

    @Test
    public void testSortIdentities() throws XMLStreamException, JAXBException {
        Identity identity1 = Identity.ofCategoryAndType((String)"AAA", (String)"aaa").withName("name1", "en");
        Identity identity2 = Identity.ofCategoryAndType((String)"AAA", (String)"aaa").withName("name2", "de");
        Identity identity3 = Identity.ofCategoryAndType((String)"AAA", (String)"bbb").withName("name2", "de");
        Identity identity4 = Identity.ofCategoryAndType((String)"BBB", (String)"bbb").withName("name2", "de");
        Identity identity5 = Identity.ofCategoryAndType((String)"BBB", (String)"aaa").withName("name1", "en");
        Identity identity6 = Identity.ofCategoryAndType((String)"CCC", (String)"aaa").withName("name2", "de");
        ArrayList<Object> identities = new ArrayList<Object>();
        identities.add(identity1);
        identities.add(identity2);
        identities.add(identity3);
        identities.add(identity4);
        identities.add(identity5);
        identities.add(identity6);
        Collections.shuffle(identities);
        identities.sort(null);
        Assert.assertEquals(identities.get(0), (Object)identity2);
        Assert.assertEquals(identities.get(1), (Object)identity1);
        Assert.assertEquals(identities.get(2), (Object)identity3);
        Assert.assertEquals(identities.get(3), (Object)identity5);
        Assert.assertEquals(identities.get(4), (Object)identity4);
        Assert.assertEquals(identities.get(5), (Object)identity6);
    }

    @Test
    public void testSortDataForms() throws XMLStreamException, JAXBException {
        DataForm dataForm1 = new DataForm(DataForm.Type.FORM, Arrays.asList(DataForm.Field.builder().var("ccc").type(DataForm.Field.Type.BOOLEAN).build(), DataForm.Field.builder().var("FORM_TYPE").value("aaa").type(DataForm.Field.Type.HIDDEN).build()));
        DataForm dataForm2 = new DataForm(DataForm.Type.FORM, Collections.singleton(DataForm.Field.builder().var("bbb").type(DataForm.Field.Type.BOOLEAN).build()));
        DataForm dataForm3 = new DataForm(DataForm.Type.FORM, Arrays.asList(DataForm.Field.builder().var("FORM_TYPE").value("bbb").type(DataForm.Field.Type.HIDDEN).build(), DataForm.Field.builder().var("aaa").type(DataForm.Field.Type.BOOLEAN).build()));
        ArrayList<Object> dataForms = new ArrayList<Object>();
        dataForms.add(dataForm1);
        dataForms.add(dataForm2);
        dataForms.add(dataForm3);
        Collections.shuffle(dataForms);
        dataForms.sort(null);
        Assert.assertEquals(dataForms.get(0), (Object)dataForm1);
        Assert.assertEquals(dataForms.get(1), (Object)dataForm3);
        Assert.assertEquals(dataForms.get(2), (Object)dataForm2);
    }

    @Test
    public void testSortDataFormFields() throws XMLStreamException, JAXBException {
        ArrayList<Object> dataFields = new ArrayList<Object>();
        DataForm.Field field1 = DataForm.Field.builder().var("ccc").type(DataForm.Field.Type.BOOLEAN).value("ccc").build();
        DataForm.Field field2 = DataForm.Field.builder().var("FORM_TYPE").value("aaa").type(DataForm.Field.Type.HIDDEN).build();
        DataForm.Field field3 = DataForm.Field.builder().var("aaa").type(DataForm.Field.Type.BOOLEAN).build();
        DataForm.Field field4 = DataForm.Field.builder().var("ggg").type(DataForm.Field.Type.BOOLEAN).build();
        DataForm.Field field5 = DataForm.Field.builder().var("eee").type(DataForm.Field.Type.BOOLEAN).build();
        dataFields.add(field1);
        dataFields.add(field2);
        dataFields.add(field3);
        dataFields.add(field4);
        dataFields.add(field5);
        Collections.shuffle(dataFields);
        dataFields.sort(null);
        Assert.assertEquals(dataFields.get(0), (Object)field2);
        Assert.assertEquals(dataFields.get(1), (Object)field3);
        Assert.assertEquals(dataFields.get(2), (Object)field1);
        Assert.assertEquals(dataFields.get(3), (Object)field5);
        Assert.assertEquals(dataFields.get(4), (Object)field4);
    }

    @Test
    public void testVerificationString() throws NoSuchAlgorithmException {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.add(Identity.clientPc().withName("Exodus 0.9.1"));
        ArrayList<String> features = new ArrayList<String>();
        features.add("http://jabber.org/protocol/disco#info");
        features.add("http://jabber.org/protocol/disco#items");
        features.add("http://jabber.org/protocol/muc");
        features.add("http://jabber.org/protocol/caps");
        InfoDiscovery infoNode = new InfoDiscovery(identities, features);
        String verificationString = EntityCapabilities.getVerificationString((InfoNode)infoNode, (MessageDigest)MessageDigest.getInstance("sha-1"));
        Assert.assertEquals((String)verificationString, (String)"QgayPKawpkPSDYmwT/WM94uAlu0=");
    }

    @Test
    public void testVerificationStringComplex() throws NoSuchAlgorithmException {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.add(Identity.clientPc().withName("Psi 0.11", "en"));
        identities.add(Identity.clientPc().withName("P 0.11", "el"));
        ArrayList<String> features = new ArrayList<String>();
        features.add("http://jabber.org/protocol/caps");
        features.add("http://jabber.org/protocol/disco#info");
        features.add("http://jabber.org/protocol/disco#items");
        features.add("http://jabber.org/protocol/muc");
        DataForm dataForm = new DataForm(DataForm.Type.RESULT, Arrays.asList(DataForm.Field.builder().var("FORM_TYPE").value("urn:xmpp:dataforms:softwareinfo").type(DataForm.Field.Type.HIDDEN).build(), DataForm.Field.builder().var("ip_version").values(Arrays.asList("ipv4", "ipv6")).type(DataForm.Field.Type.TEXT_SINGLE).build(), DataForm.Field.builder().var("os").value("Mac").type(DataForm.Field.Type.TEXT_SINGLE).build(), DataForm.Field.builder().var("os_version").value("10.5.1").type(DataForm.Field.Type.TEXT_SINGLE).build(), DataForm.Field.builder().var("software").value("Psi").type(DataForm.Field.Type.TEXT_SINGLE).build(), DataForm.Field.builder().var("software_version").value("0.11").type(DataForm.Field.Type.TEXT_SINGLE).build()));
        InfoDiscovery infoDiscovery = new InfoDiscovery(identities, features, Collections.singleton(dataForm));
        String verificationString = EntityCapabilities.getVerificationString((InfoNode)infoDiscovery, (MessageDigest)MessageDigest.getInstance("sha-1"));
        Assert.assertEquals((String)verificationString, (String)"dsMdhhH+tbCICmoptvSp3x+DafI=");
    }

    @Test
    public void testVerificationStringWithExtendedForm() throws NoSuchAlgorithmException {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.add(Identity.clientPc().withName("Exodus 0.9.1"));
        ArrayList<String> features = new ArrayList<String>();
        features.add("http://jabber.org/protocol/disco#info");
        features.add("http://jabber.org/protocol/disco#items");
        features.add("http://jabber.org/protocol/muc");
        features.add("http://jabber.org/protocol/caps");
        DataForm dataForm1 = new DataForm(DataForm.Type.FORM, Arrays.asList(DataForm.Field.builder().var("ccc").build(), DataForm.Field.builder().var("FORM_TYPE").type(DataForm.Field.Type.HIDDEN).build()));
        DataForm dataForm2 = new DataForm(DataForm.Type.FORM, Collections.singleton(DataForm.Field.builder().var("bbb").type(DataForm.Field.Type.BOOLEAN).build()));
        DataForm dataForm3 = new DataForm(DataForm.Type.FORM, Arrays.asList(DataForm.Field.builder().var("FORM_TYPE").type(DataForm.Field.Type.HIDDEN).build(), DataForm.Field.builder().var("aaa").type(DataForm.Field.Type.BOOLEAN).build()));
        InfoDiscovery infoDiscovery = new InfoDiscovery(identities, features, Arrays.asList(dataForm1, dataForm2, dataForm3));
        String verificationString = EntityCapabilities.getVerificationString((InfoNode)infoDiscovery, (MessageDigest)MessageDigest.getInstance("sha-1"));
        Assert.assertEquals((String)verificationString, (String)"EwaG/3/PLTavYdlrevpQmoqM3nw=");
    }

    @Test
    public void testVerificationString3() throws NoSuchAlgorithmException {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.add(Identity.clientPc());
        ArrayList<String> features = new ArrayList<String>();
        features.add("http://jabber.org/protocol/disco#info");
        features.add("http://jabber.org/protocol/disco#items");
        features.add("urn:xmpp:ping");
        features.add("jabber:iq:last");
        features.add("jabber:iq:version");
        features.add("http://jabber.org/protocol/ibb");
        features.add("vcard-temp");
        features.add("urn:xmpp:time");
        features.add("http://jabber.org/protocol/shim");
        features.add("http://jabber.org/protocol/caps");
        InfoDiscovery infoNode = new InfoDiscovery(identities, features);
        String verificationString = EntityCapabilities.getVerificationString((InfoNode)infoNode, (MessageDigest)MessageDigest.getInstance("sha-1"));
        Assert.assertEquals((String)verificationString, (String)"40K55pBx86cs2cR44flP35MpLCk=");
    }
}

