/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.errors;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.ClientIQ;
import rocks.xmpp.core.stanza.model.client.ClientMessage;
import rocks.xmpp.extensions.errors.model.ResourceLimitExceeded;
import rocks.xmpp.extensions.errors.model.StanzaTooBig;
import rocks.xmpp.extensions.errors.model.TooManyStanzas;

public class ErrorsTest
extends XmlTest {
    protected ErrorsTest() throws JAXBException, XMLStreamException {
        super(ClientIQ.class, ClientMessage.class, StanzaTooBig.class, TooManyStanzas.class, ResourceLimitExceeded.class);
    }

    @Test
    public void unmarshalStanzaTooBig() throws JAXBException, XMLStreamException {
        String xml = "<message from='shakespeare.lit' to='iago@shakespare.lit/evilos'>\n  <error type='modify'>\n    <not-allowed xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>\n    <stanza-too-big xmlns='urn:xmpp:errors'/>\n  </error>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        StanzaError stanzaError = message.getError();
        Assert.assertTrue((stanzaError.getExtension() == StanzaTooBig.INSTANCE ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalTooManyStanzas() throws JAXBException, XMLStreamException {
        String xml = "<message from='iago@shakespeare.lit/evilos' to='juliet@capulet.lit'>\n  <error type='wait'>\n    <unexpected-request xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>\n    <too-many-stanzas xmlns='urn:xmpp:errors'/>\n  </error>\n</message>";
        Message message = this.unmarshal(xml, Message.class);
        StanzaError stanzaError = message.getError();
        Assert.assertTrue((stanzaError.getExtension() == TooManyStanzas.INSTANCE ? 1 : 0) != 0);
    }

    @Test
    public void unmarshalResourceLimitExceeded() throws JAXBException, XMLStreamException {
        String xml = "<iq type='error' id='bind_2'>\n  <bind xmlns='urn:ietf:params:xml:ns:xmpp-bind'>\n    <resource>someresource</resource>\n  </bind>\n  <error type='cancel'>\n    <resource-constraint xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>\n    <resource-limit-exceeded xmlns='urn:xmpp:errors'/>\n  </error>\n</iq>";
        IQ iq = this.unmarshal(xml, IQ.class);
        StanzaError stanzaError = iq.getError();
        Assert.assertTrue((stanzaError.getExtension() == ResourceLimitExceeded.INSTANCE ? 1 : 0) != 0);
    }
}

