/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.util.Arrays;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.client.ClientIQ;
import rocks.xmpp.core.stanza.model.client.ClientPresence;
import rocks.xmpp.extensions.httpbind.model.Body;
import rocks.xmpp.im.roster.model.Roster;

public class BoshTest
extends XmlTest {
    protected BoshTest() throws JAXBException, XMLStreamException {
        super(ClientIQ.class, Roster.class, ClientPresence.class, Body.class);
    }

    @Test
    public void unmarshalHostGone() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='host-gone'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.HOST_GONE);
    }

    @Test
    public void unmarshalHostUnknown() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='host-unknown'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.HOST_UNKNOWN);
    }

    @Test
    public void unmarshalBadRequest() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='bad-request'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.BAD_REQUEST);
    }

    @Test
    public void unmarshalImproperAddressing() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='improper-addressing'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.IMPROPER_ADDRESSING);
    }

    @Test
    public void unmarshalInternalServerError() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='internal-server-error'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.INTERNAL_SERVER_ERROR);
    }

    @Test
    public void unmarshalItemNotFound() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='item-not-found'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.ITEM_NOT_FOUND);
    }

    @Test
    public void unmarshalOtherRequest() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='other-request'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.OTHER_REQUEST);
    }

    @Test
    public void unmarshalPolicyViolation() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='policy-violation'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.POLICY_VIOLATION);
    }

    @Test
    public void unmarshalRemoteConnectionFailed() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='remote-connection-failed'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.REMOTE_CONNECTION_FAILED);
    }

    @Test
    public void unmarshalRemoteStreamError() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='remote-stream-error'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.REMOTE_STREAM_ERROR);
    }

    @Test
    public void unmarshalSeeOtherUri() throws XMLStreamException, JAXBException {
        String xml = "<body condition='see-other-uri'\n      type='terminate'\n      xmlns='http://jabber.org/protocol/httpbind'>\n  <uri>https://secure.jabber.org/xmppcm</uri>\n</body>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((String)body.getUri().toString(), (String)"https://secure.jabber.org/xmppcm");
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.SEE_OTHER_URI);
    }

    @Test
    public void unmarshalSystemShutdown() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='system-shutdown'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.SYSTEM_SHUTDOWN);
    }

    @Test
    public void unmarshalUndefinedCondition() throws XMLStreamException, JAXBException {
        String xml = "<body type='terminate'\n      condition='undefined-condition'\n      xmlns='http://jabber.org/protocol/httpbind'/>";
        Body body = this.unmarshal(xml, Body.class);
        Assert.assertEquals((Object)body.getType(), (Object)Body.Type.TERMINATE);
        Assert.assertEquals((Object)body.getCondition(), (Object)Body.Condition.UNDEFINED_CONDITION);
    }

    @Test
    public void marshalBodyWithMultipleStanzas() throws XMLStreamException, JAXBException {
        ClientIQ iq = ClientIQ.from((IQ)new IQ(IQ.Type.GET, (Object)new Roster(), "1"));
        Body body = Body.builder().wrappedObjects(Arrays.asList(iq, ClientPresence.from((Presence)new Presence()))).build();
        Assert.assertEquals((String)this.marshal(body), (String)"<body xmlns=\"http://jabber.org/protocol/httpbind\"><iq xmlns=\"jabber:client\" id=\"1\" type=\"get\"><query xmlns=\"jabber:iq:roster\"></query></iq><presence xmlns=\"jabber:client\"></presence></body>");
    }
}

