/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rsm;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.extensions.rsm.model.ResultSetManagement;

public class ResultSetTest
extends XmlTest {
    protected ResultSetTest() throws JAXBException, XMLStreamException {
        super(ResultSetManagement.class);
    }

    @Test
    public void marshalItemCount() throws JAXBException, XMLStreamException {
        String xml = this.marshal(ResultSetManagement.forItemCount());
        Assert.assertEquals((String)xml, (String)"<set xmlns=\"http://jabber.org/protocol/rsm\"><max>0</max></set>");
    }

    @Test
    public void marshalLimit() throws JAXBException, XMLStreamException {
        String xml = this.marshal(ResultSetManagement.forLimit((int)10));
        Assert.assertEquals((String)xml, (String)"<set xmlns=\"http://jabber.org/protocol/rsm\"><max>10</max></set>");
    }

    @Test
    public void marshalForNextPage() throws JAXBException, XMLStreamException {
        String xml = this.marshal(ResultSetManagement.forNextPage((int)10, (String)"next"));
        Assert.assertEquals((String)xml, (String)"<set xmlns=\"http://jabber.org/protocol/rsm\"><max>10</max><after>next</after></set>");
    }

    @Test
    public void marshalForLastPage() throws JAXBException, XMLStreamException {
        String xml = this.marshal(ResultSetManagement.forLastPage((int)10));
        Assert.assertEquals((String)xml, (String)"<set xmlns=\"http://jabber.org/protocol/rsm\"><max>10</max><before></before></set>");
    }

    @Test
    public void marshalForPreviousPage() throws JAXBException, XMLStreamException {
        String xml = this.marshal(ResultSetManagement.forPreviousPage((int)10, (String)"previous"));
        Assert.assertEquals((String)xml, (String)"<set xmlns=\"http://jabber.org/protocol/rsm\"><max>10</max><before>previous</before></set>");
    }

    @Test
    public void marshalForIndex() throws JAXBException, XMLStreamException {
        String xml = this.marshal(ResultSetManagement.forLimit((int)10, (int)371));
        Assert.assertEquals((String)xml, (String)"<set xmlns=\"http://jabber.org/protocol/rsm\"><max>10</max><index>371</index></set>");
    }

    @Test
    public void marshalForCount() throws JAXBException, XMLStreamException {
        String xml = this.marshal(ResultSetManagement.forCount((int)10));
        Assert.assertEquals((String)xml, (String)"<set xmlns=\"http://jabber.org/protocol/rsm\"><count>10</count></set>");
        String xml2 = this.marshal(ResultSetManagement.forCount((Integer)10, (Integer)1, (String)"first", (String)"last"));
        Assert.assertEquals((String)xml2, (String)"<set xmlns=\"http://jabber.org/protocol/rsm\"><count>10</count><first index=\"1\">first</first><last>last</last></set>");
    }

    @Test
    public void unmarshalResultSet() throws XMLStreamException, JAXBException {
        String xml = "<set xmlns='http://jabber.org/protocol/rsm'>\n      <first index='0'>stpeter@jabber.org</first>\n      <last>peterpan@neverland.lit</last>\n      <count>800</count>\n    </set>";
        ResultSetManagement set = this.unmarshal(xml, ResultSetManagement.class);
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((String)set.getFirstItem(), (String)"stpeter@jabber.org");
        Assert.assertEquals((Object)set.getFirstItemIndex(), (Object)0);
        Assert.assertEquals((String)set.getLastItem(), (String)"peterpan@neverland.lit");
        Assert.assertEquals((Object)set.getItemCount(), (Object)800);
    }
}

