/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.sm;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.sm.model.StreamManagement;

public class StreamManagementTest
extends XmlTest {
    protected StreamManagementTest() throws JAXBException, XMLStreamException {
        super(StreamManagement.class);
    }

    @Test
    public void unmarshalFeature() throws XMLStreamException, JAXBException {
        String xml = "<sm xmlns='urn:xmpp:sm:3'/>";
        StreamManagement feature = this.unmarshal(xml, StreamManagement.class);
        Assert.assertNotNull((Object)feature);
    }

    @Test
    public void marshalEnable() throws JAXBException, XMLStreamException {
        StreamManagement.Enable enable = new StreamManagement.Enable();
        String xml = this.marshal(enable);
        Assert.assertEquals((String)"<enable xmlns=\"urn:xmpp:sm:3\"></enable>", (String)xml);
    }

    @Test
    public void marshalEnableWithResume() throws JAXBException, XMLStreamException {
        StreamManagement.Enable enable = new StreamManagement.Enable(Boolean.valueOf(true), Integer.valueOf(23));
        String xml = this.marshal(enable);
        Assert.assertEquals((String)"<enable xmlns=\"urn:xmpp:sm:3\" resume=\"true\" max=\"23\"></enable>", (String)xml);
    }

    @Test
    public void unmarshalEnabled() throws XMLStreamException, JAXBException {
        String xml = "<enabled xmlns='urn:xmpp:sm:3' id='some-long-sm-id' resume='true' max='23' location='domain'/>";
        StreamManagement.Enabled enabled = this.unmarshal(xml, StreamManagement.Enabled.class);
        Assert.assertNotNull((Object)enabled);
        Assert.assertEquals((String)enabled.getId(), (String)"some-long-sm-id");
        Assert.assertTrue((boolean)enabled.isResume());
        Assert.assertEquals((String)enabled.getLocation(), (String)"domain");
        Assert.assertEquals((Object)enabled.getMax(), (Object)23);
    }

    @Test
    public void unmarshalFailed() throws XMLStreamException, JAXBException {
        String xml = "<failed xmlns='urn:xmpp:sm:3'>\n     <unexpected-request xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>\n   </failed>";
        StreamManagement.Failed failed = this.unmarshal(xml, StreamManagement.Failed.class);
        Assert.assertNotNull((Object)failed);
        Assert.assertTrue((failed.getError() == Condition.UNEXPECTED_REQUEST ? 1 : 0) != 0);
    }

    @Test
    public void marshalAnswer() throws JAXBException, XMLStreamException {
        StreamManagement.Answer answer = new StreamManagement.Answer(1L);
        String xml = this.marshal(answer);
        Assert.assertEquals((String)"<a xmlns=\"urn:xmpp:sm:3\" h=\"1\"></a>", (String)xml);
    }

    @Test
    public void marshalRequest() throws JAXBException, XMLStreamException {
        String xml = this.marshal(StreamManagement.REQUEST);
        Assert.assertEquals((String)"<r xmlns=\"urn:xmpp:sm:3\"></r>", (String)xml);
    }

    @Test
    public void unmarshalResume() throws XMLStreamException, JAXBException {
        String xml = "<resume xmlns='urn:xmpp:sm:3' \n            h='2'\n            previd='some-long-sm-id'/>\n";
        StreamManagement.Resume resume = this.unmarshal(xml, StreamManagement.Resume.class);
        Assert.assertNotNull((Object)resume);
        Assert.assertEquals((String)resume.getPreviousId(), (String)"some-long-sm-id");
        Assert.assertEquals((long)resume.getLastHandledStanza(), (long)2L);
    }

    @Test
    public void unmarshalResumed() throws XMLStreamException, JAXBException {
        String xml = "<resumed xmlns='urn:xmpp:sm:3' \n            h='2'\n            previd='some-long-sm-id'/>\n";
        StreamManagement.Resumed resumed = this.unmarshal(xml, StreamManagement.Resumed.class);
        Assert.assertNotNull((Object)resumed);
        Assert.assertEquals((String)resumed.getPreviousId(), (String)"some-long-sm-id");
        Assert.assertEquals((long)resumed.getLastHandledStanza(), (long)2L);
    }
}

