/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.sasl.scram;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.xml.bind.DatatypeConverter;
import rocks.xmpp.core.sasl.scram.SaslPrep;
import rocks.xmpp.core.sasl.scram.ScramBase;

public final class ScramClient
extends ScramBase
implements SaslClient {
    private static final String GS2_CBIND_FLAG = "n";
    private final String gs2Header;
    String username;
    private String authorizationId;
    private char[] passwd;

    public ScramClient(String hashAlgorithm, String authorizationId, CallbackHandler callbackHandler) {
        super(hashAlgorithm, callbackHandler);
        if (authorizationId != null) {
            this.authorizationId = new String(authorizationId.getBytes(StandardCharsets.UTF_8));
        }
        this.gs2Header = "n," + (authorizationId != null ? "a=" + authorizationId : "") + ',';
    }

    static String replaceUsername(String username) {
        if (username != null) {
            return username.replace("=", "=3D").replace(",", "=2C");
        }
        return null;
    }

    @Override
    public final boolean hasInitialResponse() {
        return true;
    }

    @Override
    public final byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        Integer iterationCount;
        if (challenge.length == 0) {
            String cnonce;
            NameCallback ncb = this.authorizationId == null ? new NameCallback("SCRAM username: ") : new NameCallback("SCRAM username: ", this.authorizationId);
            PasswordCallback pcb = new PasswordCallback("SCRAM-SHA-1 password: ", false);
            try {
                this.callbackHandler.handle(new Callback[]{ncb, pcb});
                this.passwd = pcb.getPassword();
                pcb.clearPassword();
                this.username = ncb.getName();
                if (this.passwd == null || this.username == null) {
                    throw new SaslException("SCRAM: Username and password must not be null.");
                }
                this.username = SaslPrep.prepare(this.username);
                if ("".equals(this.username)) {
                    throw new SaslException("SCRAM: Username must not be empty.");
                }
                this.username = ScramClient.replaceUsername(this.username);
            }
            catch (IOException e) {
                throw new SaslException("SCRAM: Error acquiring user name or password.", e);
            }
            catch (UnsupportedCallbackException e) {
                throw new SaslException("SCRAM: Cannot perform callback to acquire username or password", e);
            }
            try {
                cnonce = ScramClient.generateNonce();
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("SCRAM: Failed to generate nonce.", e);
            }
            this.clientFirstMessageBare = ScramClient.createClientFirstMessageBare(this.username, cnonce);
            String clientFirstMessage = this.gs2Header + this.clientFirstMessageBare;
            return clientFirstMessage.getBytes(StandardCharsets.UTF_8);
        }
        this.serverFirstMessage = new String(challenge);
        Map<Character, String> attributes = ScramClient.getAttributes(this.serverFirstMessage);
        this.nonce = attributes.get(Character.valueOf('r'));
        String saltBase64 = attributes.get(Character.valueOf('s'));
        try {
            iterationCount = Integer.parseInt(attributes.get(Character.valueOf('i')));
        }
        catch (NumberFormatException e) {
            throw new SaslException("iterationCount could not be parsed.");
        }
        if (this.nonce == null) {
            throw new SaslException("SCRAM: nonce was null in the server response.");
        }
        if (saltBase64 == null) {
            throw new SaslException("SCRAM: salt was null in the server response.");
        }
        byte[] salt = DatatypeConverter.parseBase64Binary((String)saltBase64);
        try {
            this.channelBinding = DatatypeConverter.printBase64Binary((byte[])this.gs2Header.getBytes(StandardCharsets.UTF_8));
            byte[] clientKey = this.computeClientKey(this.computeSaltedPassword(this.passwd, salt, iterationCount));
            byte[] clientSignature = this.computeClientSignature(clientKey, this.computeAuthMessage());
            byte[] clientProof = ScramClient.xor(clientKey, clientSignature);
            String clientFinalMessageWithoutProof = "c=" + this.channelBinding + ",r=" + this.nonce;
            String clientFinalMessage = clientFinalMessageWithoutProof + ",p=" + DatatypeConverter.printBase64Binary((byte[])clientProof);
            return clientFinalMessage.getBytes(StandardCharsets.UTF_8);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }
}

