/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.sasl.scram;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.xml.bind.DatatypeConverter;
import rocks.xmpp.core.sasl.scram.SaslPrep;
import rocks.xmpp.core.sasl.scram.ScramBase;

final class ScramServer
extends ScramBase
implements SaslServer {
    private static final int ITERATION_COUNT = 4096;
    private static final Pattern USER_VALIDATION = Pattern.compile("=(?!2C|3D)");
    private char[] password;
    private byte[] salt;
    private String authorizationId;

    public ScramServer(String hashAlgorithm, CallbackHandler callbackHandler) {
        super(hashAlgorithm, callbackHandler);
    }

    static String validateAndGetUsername(String userAttribute) throws SaslException {
        if (userAttribute != null) {
            Matcher matcher = USER_VALIDATION.matcher(userAttribute);
            if (matcher.find()) {
                throw new SaslException("Username must not contain '=' not followed by '2C' or '3D'.");
            }
            return userAttribute.replaceAll("=3D", "=").replaceAll("=2C", ",");
        }
        return null;
    }

    @Override
    public final byte[] evaluateResponse(byte[] response) throws SaslException {
        String clientMessage = new String(response);
        Map<Character, String> attributes = ScramServer.getAttributes(clientMessage);
        String cnonce = attributes.get(Character.valueOf('r'));
        if (cnonce == null) {
            throw new SaslException("SCRAM: No nonce found in client message.");
        }
        if (this.clientFirstMessageBare == null) {
            if (!(clientMessage.startsWith("n") || clientMessage.startsWith("y") || clientMessage.startsWith("p"))) {
                throw new SaslException("SCRAM: Client first message must start with n, y or p.");
            }
            String user = attributes.get(Character.valueOf('n'));
            if (user == null) {
                throw new SaslException("SCRAM: No user found in client first message.");
            }
            user = ScramServer.validateAndGetUsername(SaslPrep.prepare(attributes.get(Character.valueOf('n'))));
            this.authorizationId = ScramServer.validateAndGetUsername(attributes.get(Character.valueOf('a')));
            NameCallback ncb = new NameCallback("SCRAM username: ", user);
            ncb.setName(user);
            PasswordCallback pcb = new PasswordCallback("SCRAM password: ", false);
            try {
                this.callbackHandler.handle(new Callback[]{ncb, pcb});
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw new SaslException("SCRAM: Error retrieving password.");
            }
            this.password = pcb.getPassword();
            pcb.clearPassword();
            SecureRandom r = new SecureRandom();
            this.salt = new byte[32];
            ((Random)r).nextBytes(this.salt);
            try {
                this.nonce = cnonce + ScramServer.generateNonce();
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException();
            }
            this.clientFirstMessageBare = ScramServer.createClientFirstMessageBare(user, cnonce);
            this.serverFirstMessage = "r=" + this.nonce + ",s=" + DatatypeConverter.printBase64Binary((byte[])this.salt) + ",i=" + 4096;
            return this.serverFirstMessage.getBytes(StandardCharsets.UTF_8);
        }
        if (!cnonce.equals(this.nonce)) {
            throw new SaslException("SCRAM: Client provided invalid nonce.");
        }
        String clientProofBase64 = attributes.get(Character.valueOf('p'));
        if (clientProofBase64 == null) {
            throw new SaslException("SCRAM: Client provided no client proof.");
        }
        this.channelBinding = attributes.get(Character.valueOf('c'));
        if (this.channelBinding == null) {
            throw new SaslException("SCRAM: Client provided no channel-binding.");
        }
        try {
            byte[] saltedPassword = this.computeSaltedPassword(this.password, this.salt, 4096);
            byte[] clientKey = this.computeClientKey(saltedPassword);
            String authMessage = this.computeAuthMessage();
            byte[] clientSignature = this.computeClientSignature(clientKey, authMessage);
            byte[] clientProof = DatatypeConverter.parseBase64Binary((String)clientProofBase64);
            byte[] recoveredClientKey = ScramServer.xor(clientSignature, clientProof);
            if (Arrays.equals(this.h(recoveredClientKey), this.computeStoredKey(clientKey))) {
                this.isComplete = true;
                byte[] serverKey = this.hmac(saltedPassword, "Server Key".getBytes(StandardCharsets.UTF_8));
                String serverFinalMessage = "v=" + DatatypeConverter.printBase64Binary((byte[])this.hmac(serverKey, authMessage.getBytes(StandardCharsets.UTF_8)));
                return serverFinalMessage.getBytes(StandardCharsets.UTF_8);
            }
            throw new SaslException("SCRAM authentication failed.");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SaslException("SCRAM", e);
        }
    }

    @Override
    public final String getAuthorizationID() {
        return this.authorizationId;
    }
}

