/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EventObject;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.util.BranchedInputStream;
import rocks.xmpp.util.BranchedOutputStream;
import rocks.xmpp.util.PrefixFreeCanonicalizationWriter;

public final class XmppUtils {
    private static final Logger logger = Logger.getLogger(XmppUtils.class.getName());

    private XmppUtils() {
    }

    public static XMLStreamWriter createXmppStreamWriter(XMLStreamWriter xmlStreamWriter, String contentNamespace) throws XMLStreamException {
        return new PrefixFreeCanonicalizationWriter(xmlStreamWriter, contentNamespace);
    }

    public static XMLStreamWriter createXmppStreamWriter(XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        return XmppUtils.createXmppStreamWriter(xmlStreamWriter, "jabber:client");
    }

    public static InputStream createBranchedInputStream(InputStream source, OutputStream target) {
        return new BranchedInputStream(source, target);
    }

    public static OutputStream createBranchedOutputStream(OutputStream out, OutputStream branch) {
        return new BranchedOutputStream(out, branch);
    }

    public static String hash(byte[] bytes) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
            return String.format("%040x", new BigInteger(1, messageDigest.digest(bytes)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static ThreadFactory createNamedThreadFactory(String threadName) {
        return r -> {
            Thread thread = new Thread(r, threadName);
            thread.setDaemon(true);
            return thread;
        };
    }

    public static <T extends EventObject> void notifyEventListeners(Iterable<Consumer<T>> eventListeners, T e) {
        eventListeners.forEach(listener -> {
            try {
                listener.accept(e);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        });
    }
}

