/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.client.ClientIQ;
import rocks.xmpp.core.stanza.model.client.ClientMessage;
import rocks.xmpp.core.stanza.model.client.ClientPresence;
import rocks.xmpp.util.XmppUtils;

public abstract class XmlTest {
    private static final String START_STREAM = "<?xml version='1.0' encoding='UTF-8'?><stream:stream xmlns:stream=\"http://etherx.jabber.org/streams\" xmlns=\"${namespace}\" from=\"localhost\" id=\"55aa4529\" xml:lang=\"en\" version=\"1.0\">";
    private static final String END_STREAM = "</stream:stream>";
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newFactory();
    private static final XMLOutputFactory OUTPUT_FACTORY = XMLOutputFactory.newFactory();
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;
    private final String namespace;

    protected XmlTest(Class<?> ... context) throws JAXBException, XMLStreamException {
        this("jabber:client", context);
    }

    protected XmlTest(String namespace, Class<?> ... context) throws JAXBException, XMLStreamException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])context);
        this.unmarshaller = jaxbContext.createUnmarshaller();
        this.marshaller = jaxbContext.createMarshaller();
        this.marshaller.setProperty("jaxb.fragment", (Object)true);
        this.namespace = namespace;
    }

    private XMLEventReader getStream(String stanza) throws XMLStreamException {
        XMLEventReader xmlEventReader = INPUT_FACTORY.createXMLEventReader(new StringReader(START_STREAM.replace("${namespace}", this.namespace) + stanza + END_STREAM));
        xmlEventReader.nextEvent();
        xmlEventReader.nextEvent();
        return xmlEventReader;
    }

    protected <T> T unmarshal(String xml, Class<T> type) throws XMLStreamException, JAXBException {
        Class<Object> clazz = type;
        if (type == Message.class) {
            clazz = ClientMessage.class;
        }
        if (type == Presence.class) {
            clazz = ClientPresence.class;
        }
        if (type == IQ.class) {
            clazz = ClientIQ.class;
        }
        XMLEventReader xmlEventReader = this.getStream(xml);
        return (T)this.unmarshaller.unmarshal(xmlEventReader, clazz).getValue();
    }

    protected Object unmarshal(String xml) throws XMLStreamException, JAXBException {
        XMLEventReader xmlEventReader = this.getStream(xml);
        return this.unmarshaller.unmarshal(xmlEventReader);
    }

    protected String marshal(Object object) throws XMLStreamException, JAXBException {
        if (object instanceof Message) {
            object = ClientMessage.from((Message)((Message)object));
        }
        if (object instanceof Presence) {
            object = ClientPresence.from((Presence)((Presence)object));
        }
        if (object instanceof IQ) {
            object = ClientIQ.from((IQ)((IQ)object));
        }
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlStreamWriter = OUTPUT_FACTORY.createXMLStreamWriter(writer);
        XMLStreamWriter prefixFreeWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)xmlStreamWriter, (String)this.namespace);
        this.marshaller.marshal(object, prefixFreeWriter);
        prefixFreeWriter.flush();
        return ((Object)writer).toString();
    }
}

