/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco.model.info;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;

public final class Identity
implements Comparable<Identity> {
    private static final String ACCOUNT = "account";
    private static final String AUTH = "auth";
    private static final String AUTOMATION = "automation";
    private static final String CLIENT = "client";
    private static final String COLLABORATION = "collaboration";
    private static final String COMPONENT = "component";
    private static final String CONFERENCE = "conference";
    private static final String DIRECTORY = "directory";
    private static final String GATEWAY = "gateway";
    private static final String HEADLINE = "headline";
    private static final String HIERARCHY = "hierarchy";
    private static final String PROXY = "proxy";
    private static final String PUBSUB = "pubsub";
    private static final String SERVER = "server";
    private static final String STORE = "store";
    @XmlAttribute
    private final String category;
    @XmlAttribute
    private final String type;
    @XmlAttribute
    private final String name;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    private final String lang;

    private Identity() {
        this.category = null;
        this.type = null;
        this.name = null;
        this.lang = null;
    }

    @Deprecated
    public Identity(String category, String type) {
        this(category, type, null);
    }

    @Deprecated
    public Identity(String category, String type, String name) {
        this(category, type, name, null);
    }

    @Deprecated
    public Identity(String category, String type, String name, String language) {
        this.category = Objects.requireNonNull(category);
        this.type = Objects.requireNonNull(type);
        this.name = name;
        this.lang = language;
    }

    public static Identity ofCategoryAndType(String category, String type) {
        return new Identity(Objects.requireNonNull(category), Objects.requireNonNull(type));
    }

    public static Identity accountAdmin() {
        return new Identity(ACCOUNT, "admin");
    }

    public static Identity accountAnonymous() {
        return new Identity(ACCOUNT, "anonymous");
    }

    public static Identity accountRegistered() {
        return new Identity(ACCOUNT, "registered");
    }

    public static Identity authCert() {
        return new Identity(AUTH, "cert");
    }

    public static Identity authGeneric() {
        return new Identity(AUTH, "generic");
    }

    public static Identity authLdap() {
        return new Identity(AUTH, "ldap");
    }

    public static Identity authNtlm() {
        return new Identity(AUTH, "ntlm");
    }

    public static Identity authPam() {
        return new Identity(AUTH, "pam");
    }

    public static Identity automationCommandList() {
        return new Identity(AUTOMATION, "command-list");
    }

    public static Identity automationCommandNode() {
        return new Identity(AUTOMATION, "command-node");
    }

    public static Identity automationRpc() {
        return new Identity(AUTOMATION, "rpc");
    }

    public static Identity automationSoap() {
        return new Identity(AUTOMATION, "soap");
    }

    public static Identity automationTranslation() {
        return new Identity(AUTOMATION, "translation");
    }

    public static Identity clientBot() {
        return new Identity(CLIENT, "bot");
    }

    public static Identity clientConsole() {
        return new Identity(CLIENT, "console");
    }

    public static Identity clientGame() {
        return new Identity(CLIENT, "game");
    }

    public static Identity clientHandheld() {
        return new Identity(CLIENT, "handheld");
    }

    public static Identity clientPc() {
        return new Identity(CLIENT, "pc");
    }

    public static Identity clientPhone() {
        return new Identity(CLIENT, "phone");
    }

    public static Identity clientSms() {
        return new Identity(CLIENT, "sms");
    }

    public static Identity clientWeb() {
        return new Identity(CLIENT, "web");
    }

    public static Identity collaborationWhiteboard() {
        return new Identity(COLLABORATION, "whiteboard");
    }

    public static Identity componentArchive() {
        return new Identity(COMPONENT, "archive");
    }

    public static Identity componentClientToServer() {
        return new Identity(COMPONENT, "c2s");
    }

    public static Identity componentGeneric() {
        return new Identity(COMPONENT, "generic");
    }

    public static Identity componentLoadBalancing() {
        return new Identity(COMPONENT, "load");
    }

    public static Identity componentLog() {
        return new Identity(COMPONENT, "log");
    }

    public static Identity componentPresence() {
        return new Identity(COMPONENT, "presence");
    }

    public static Identity componentRouter() {
        return new Identity(COMPONENT, "router");
    }

    public static Identity componentServerToServer() {
        return new Identity(COMPONENT, "s2s");
    }

    public static Identity componentSessionManagement() {
        return new Identity(COMPONENT, "sm");
    }

    public static Identity componentStatistics() {
        return new Identity(COMPONENT, "stats");
    }

    public static Identity conferenceIrc() {
        return new Identity(CONFERENCE, "irc");
    }

    public static Identity conferenceText() {
        return new Identity(CONFERENCE, "text");
    }

    public static Identity directoryChatRoom() {
        return new Identity(DIRECTORY, "chatroom");
    }

    public static Identity directoryGroup() {
        return new Identity(DIRECTORY, "group");
    }

    public static Identity directoryUser() {
        return new Identity(DIRECTORY, "user");
    }

    public static Identity directoryWaitingList() {
        return new Identity(DIRECTORY, "waitinglist");
    }

    public static Identity gatewayAIM() {
        return new Identity(GATEWAY, "aim");
    }

    public static Identity gatewayFacebook() {
        return new Identity(GATEWAY, "facebook");
    }

    public static Identity gatewayGaduGadu() {
        return new Identity(GATEWAY, "gadu-gadu");
    }

    public static Identity gatewayHttpWs() {
        return new Identity(GATEWAY, "http-ws");
    }

    public static Identity gatewayICQ() {
        return new Identity(GATEWAY, "icq");
    }

    public static Identity gatewayIRC() {
        return new Identity(GATEWAY, "irc");
    }

    public static Identity gatewayLCS() {
        return new Identity(GATEWAY, "lcs");
    }

    public static Identity gatewayMSN() {
        return new Identity(GATEWAY, "msn");
    }

    public static Identity gatewayMySpaceIM() {
        return new Identity(GATEWAY, "myspaceim");
    }

    public static Identity gatewayOCS() {
        return new Identity(GATEWAY, "ocs");
    }

    public static Identity gatewayQQ() {
        return new Identity(GATEWAY, "qq");
    }

    public static Identity gatewaySametime() {
        return new Identity(GATEWAY, "sametime");
    }

    public static Identity gatewaySimple() {
        return new Identity(GATEWAY, "simple");
    }

    public static Identity gatewaySkype() {
        return new Identity(GATEWAY, "skype");
    }

    public static Identity gatewaySMS() {
        return new Identity(GATEWAY, "sms");
    }

    public static Identity gatewaySMTP() {
        return new Identity(GATEWAY, "smtp");
    }

    public static Identity gatewayTlen() {
        return new Identity(GATEWAY, "tlen");
    }

    public static Identity gatewayXfire() {
        return new Identity(GATEWAY, "xfire");
    }

    public static Identity gatewayXMPP() {
        return new Identity(GATEWAY, "xmpp");
    }

    public static Identity gatewayYahoo() {
        return new Identity(GATEWAY, "yahoo");
    }

    public static Identity headlineNewMail() {
        return new Identity(HEADLINE, "newmail");
    }

    public static Identity headlineRss() {
        return new Identity(HEADLINE, "rss");
    }

    public static Identity headlineWeather() {
        return new Identity(HEADLINE, "weather");
    }

    public static Identity hierarchyBranch() {
        return new Identity(HIERARCHY, "branch");
    }

    public static Identity hierarchyLeaf() {
        return new Identity(HIERARCHY, "leaf");
    }

    public static Identity proxyByteStreams() {
        return new Identity(PROXY, "bytestreams");
    }

    public static Identity pubsubCollection() {
        return new Identity(PUBSUB, "collection");
    }

    public static Identity pubsubLeaf() {
        return new Identity(PUBSUB, "leaf");
    }

    public static Identity pubsubPersonalEventingService() {
        return new Identity(PUBSUB, "pep");
    }

    public static Identity pubsubService() {
        return new Identity(PUBSUB, "service");
    }

    public static Identity serverInstantMessaging() {
        return new Identity(SERVER, "im");
    }

    public static Identity storeBerkeley() {
        return new Identity(STORE, "berkeley");
    }

    public static Identity storeFile() {
        return new Identity(STORE, "file");
    }

    public static Identity storeGeneric() {
        return new Identity(STORE, "generic");
    }

    public static Identity storeLdap() {
        return new Identity(STORE, "ldap");
    }

    public static Identity storeMySQL() {
        return new Identity(STORE, "mysql");
    }

    public static Identity storeOracle() {
        return new Identity(STORE, "oracle");
    }

    public static Identity storePostgreSQL() {
        return new Identity(STORE, "postgres");
    }

    public final String getCategory() {
        return this.category;
    }

    public final String getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final String getLanguage() {
        return this.lang;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Identity)) {
            return false;
        }
        Identity other = (Identity)o;
        return Objects.equals(this.category, other.category) && Objects.equals(this.type, other.type) && Objects.equals(this.lang, other.lang);
    }

    public final int hashCode() {
        return Objects.hash(this.category, this.type, this.lang);
    }

    @Override
    public final int compareTo(Identity o) {
        int result;
        if (o == null) {
            result = 1;
        } else {
            result = this.category == null && o.category == null ? 0 : (this.category == null ? -1 : (o.category == null ? 1 : this.category.compareTo(o.category)));
            if (result == 0) {
                result = this.type == null && o.type == null ? 0 : (this.type == null ? -1 : (o.type == null ? 1 : this.type.compareTo(o.type)));
            }
            if (result == 0) {
                result = this.lang == null && o.lang == null ? 0 : (this.lang == null ? -1 : (o.lang == null ? 1 : this.lang.compareTo(o.lang)));
            }
            if (result == 0) {
                if (this.name == null && o.name == null) {
                    return 0;
                }
                if (this.name == null) {
                    return -1;
                }
                if (o.name == null) {
                    return 1;
                }
                return this.name.compareTo(o.name);
            }
        }
        return result;
    }

    public final String toString() {
        return "Category: " + this.category + " / Type: " + this.type + " / Name: " + this.name;
    }

    public Identity withName(String name) {
        return new Identity(this.category, this.type, name, this.lang);
    }

    public Identity withName(String name, String language) {
        return new Identity(this.category, this.type, name, language);
    }
}

