/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlEnum;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.Text;
import rocks.xmpp.core.stanza.model.errors.Condition;

public final class StanzaError {
    @XmlAttribute
    private final Jid by;
    @XmlAttribute
    private final Type type;
    @XmlElementRef
    private final Condition condition;
    @XmlElement(namespace="urn:ietf:params:xml:ns:xmpp-stanzas")
    private final Text text;
    @XmlAnyElement(lax=true)
    private final Object extension;

    private StanzaError() {
        this(null, Condition.UNDEFINED_CONDITION, null, null, null, null);
    }

    public StanzaError(Type type, Condition condition) {
        this(type, condition, null);
    }

    public StanzaError(Type type, Condition condition, String text) {
        this(type, condition, text, null, null, null);
    }

    public StanzaError(Condition condition) {
        this(condition, null);
    }

    public StanzaError(Condition condition, String text) {
        this(null, condition, text, null, null, null);
    }

    public StanzaError(Condition condition, Object extension) {
        this(null, condition, null, null, extension, null);
    }

    public StanzaError(Type type, Condition condition, String text, String language, Object extension, Jid by) {
        this.condition = Objects.requireNonNull(condition);
        this.type = type == null ? Condition.getErrorTypeByCondition(condition) : type;
        this.text = text != null ? new Text(text, language) : null;
        this.extension = extension;
        this.by = by;
    }

    public final Jid getBy() {
        return this.by;
    }

    public final Type getType() {
        return this.type;
    }

    public final String getText() {
        if (this.text != null) {
            return this.text.getText();
        }
        return null;
    }

    public final String getLanguage() {
        if (this.text != null) {
            return this.text.getLanguage();
        }
        return null;
    }

    public final Object getExtension() {
        return this.extension;
    }

    public final Condition getCondition() {
        if (this.condition != null) {
            return this.condition;
        }
        return Condition.UNDEFINED_CONDITION;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.condition).append("  -  (").append((Object)this.type).append(')');
        if (this.text != null) {
            sb.append("\n        ").append(this.text);
        }
        if (this.extension != null) {
            sb.append("\n        ").append(this.extension);
        }
        return sb.toString();
    }

    @XmlEnum
    public static enum Type {
        AUTH("retry after providing credentials"),
        CANCEL("do not retry (the error cannot be remedied)"),
        CONTINUE("proceed (the condition was only a warning)"),
        MODIFY("retry after changing the data sent"),
        WAIT("retry after waiting (the error is temporary)");

        private final String errorText;

        private Type(String errorText) {
            this.errorText = errorText;
        }

        public final String toString() {
            return "type '" + this.name().toLowerCase() + "': " + this.errorText;
        }
    }
}

