/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps.model;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeSet;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;

@XmlRootElement(name="c")
public final class EntityCapabilities
extends StreamFeature {
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    @XmlAttribute
    private final String hash;
    @XmlAttribute
    private final String node;
    @XmlAttribute
    private final String ver;

    private EntityCapabilities() {
        this.node = null;
        this.hash = null;
        this.ver = null;
    }

    public EntityCapabilities(String node, String hash, String ver) {
        this.node = Objects.requireNonNull(node);
        this.hash = Objects.requireNonNull(hash);
        this.ver = Objects.requireNonNull(ver);
    }

    public static String getVerificationString(InfoNode infoNode, MessageDigest messageDigest) {
        TreeSet<Identity> identities = new TreeSet<Identity>(infoNode.getIdentities());
        TreeSet<String> features = new TreeSet<String>(infoNode.getFeatures());
        ArrayList<DataForm> dataForms = new ArrayList<DataForm>(infoNode.getExtensions());
        StringBuilder sb = new StringBuilder();
        for (Identity identity : identities) {
            if (identity.getCategory() != null) {
                sb.append(identity.getCategory());
            }
            sb.append('/');
            if (identity.getType() != null) {
                sb.append(identity.getType());
            }
            sb.append('/');
            if (identity.getLanguage() != null) {
                sb.append(identity.getLanguage());
            }
            sb.append('/');
            if (identity.getName() != null) {
                sb.append(identity.getName());
            }
            sb.append('<');
        }
        for (String feature : features) {
            if (feature != null) {
                sb.append(feature);
            }
            sb.append('<');
        }
        dataForms.sort(null);
        for (DataForm dataForm : dataForms) {
            ArrayList<DataForm.Field> fields = new ArrayList<DataForm.Field>(dataForm.getFields());
            fields.sort(null);
            if (fields.isEmpty() || !"FORM_TYPE".equals(((DataForm.Field)fields.get(0)).getVar()) || ((DataForm.Field)fields.get(0)).getType() != DataForm.Field.Type.HIDDEN) continue;
            for (DataForm.Field field : fields) {
                ArrayList<String> values = new ArrayList<String>(field.getValues());
                if (!"FORM_TYPE".equals(field.getVar())) {
                    sb.append(field.getVar()).append('<');
                    values.sort(null);
                }
                for (String value : values) {
                    sb.append(value).append('<');
                }
            }
        }
        messageDigest.reset();
        return DatatypeConverter.printBase64Binary((byte[])messageDigest.digest(sb.toString().getBytes(StandardCharsets.UTF_8)));
    }

    public final String getHashingAlgorithm() {
        return this.hash;
    }

    public final String getNode() {
        return this.node;
    }

    public final String getVerificationString() {
        return this.ver;
    }

    public final String toString() {
        return this.ver;
    }
}

