/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.Condition;

@XmlTransient
public class IQ
extends Stanza {
    private static final EnumSet<Type> IS_REQUEST = EnumSet.of(Type.GET, Type.SET);
    private static final EnumSet<Type> IS_RESPONSE = EnumSet.of(Type.RESULT, Type.ERROR);
    @XmlAttribute
    private Type type;

    protected IQ() {
        this.type = null;
    }

    public IQ(Type type, Object extension) {
        this(type, extension, null);
    }

    public IQ(Type type, Object extension, String id) {
        this(null, type, extension, id);
    }

    public IQ(Jid to, Type type, Object extension) {
        this(to, type, extension, null);
    }

    public IQ(Jid to, Type type, Object extension, String id) {
        this(to, type, extension, id, null, null, null);
    }

    public IQ(Jid to, Type type, Object extension, String id, Jid from, Locale language, StanzaError error) {
        super(to, from, id == null ? UUID.randomUUID().toString() : id, language, extension != null ? Collections.singleton(extension) : Collections.emptyList(), error);
        this.type = Objects.requireNonNull(type, "type must not be null.");
    }

    public static IQ get(Jid to, Object extension) {
        return new IQ(to, Type.GET, Objects.requireNonNull(extension));
    }

    public static IQ set(Jid to, Object extension) {
        return new IQ(to, Type.SET, Objects.requireNonNull(extension));
    }

    public static IQ get(Object extension) {
        return IQ.get(null, extension);
    }

    public static IQ set(Object extension) {
        return IQ.set(null, extension);
    }

    public final synchronized Type getType() {
        return this.type;
    }

    public final synchronized void setType(Type type) {
        this.type = type;
    }

    @Override
    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder("IQ");
        if (this.type != null) {
            sb.append('-').append(this.type.name().toLowerCase());
        }
        return sb.append(super.toString()).toString();
    }

    public final synchronized boolean isRequest() {
        return IS_REQUEST.contains((Object)this.type);
    }

    public final synchronized boolean isResponse() {
        return IS_RESPONSE.contains((Object)this.type);
    }

    public IQ createResult() {
        return this.createResult(null);
    }

    public final IQ createResult(Object extension) {
        return new IQ(this.getFrom(), Type.RESULT, extension, this.getId(), this.getTo(), this.getLanguage(), null);
    }

    @Override
    public final IQ createError(StanzaError error) {
        return new IQ(this.getFrom(), Type.ERROR, null, this.getId(), this.getTo(), this.getLanguage(), error);
    }

    @Override
    public final IQ createError(Condition condition) {
        return this.createError(new StanzaError(condition));
    }

    @XmlType(name="iqType")
    public static enum Type {
        ERROR,
        GET,
        RESULT,
        SET;

    }
}

