/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.sasl.scram;

import java.text.Bidi;
import java.text.Normalizer;
import java.util.regex.Pattern;

final class SaslPrep {
    private static final Pattern MAP_TO_SPACE = Pattern.compile("([\u00a0\u1680\u2000-\u200b\u202f\u205f\u3000])");
    private static final Pattern MAP_TO_NOTHING = Pattern.compile("([\u00ad\u034f\u1806\u180b-\u180d\u200b-\u200d\u2060\ufe00-\ufe0f\ufeff])");
    private static final Pattern PROHIBITED_CHARACTERS = Pattern.compile("[^\\p{L}\\p{N}\\p{P}\\p{S}\\p{M}\\s]");

    private SaslPrep() {
    }

    static String prepare(String input) {
        Bidi bidi;
        String prepared = MAP_TO_NOTHING.matcher(MAP_TO_SPACE.matcher(input).replaceAll(" ")).replaceAll("");
        if (PROHIBITED_CHARACTERS.matcher(prepared = Normalizer.normalize(prepared, Normalizer.Form.NFKC)).find()) {
            throw new IllegalArgumentException("Input string contains prohibited characters");
        }
        if (Bidi.requiresBidi(prepared.toCharArray(), 0, prepared.length()) && (bidi = new Bidi(input, 0)).isMixed() && (bidi.getLevelAt(0) != 1 || bidi.getLevelAt(0) != bidi.getLevelAt(input.length() - 1))) {
            throw new IllegalArgumentException("String contains mixed bidirectional characters.");
        }
        return prepared;
    }
}

