/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.sasl.model;

import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.core.stream.model.StreamElement;

@XmlRootElement
public final class Failure
implements StreamElement {
    @XmlElements(value={@XmlElement(name="aborted", type=Aborted.class), @XmlElement(name="account-disabled", type=AccountDisabled.class), @XmlElement(name="credentials-expired", type=CredentialsExpired.class), @XmlElement(name="encryption-required", type=EncryptionRequired.class), @XmlElement(name="incorrect-encoding", type=IncorrectEncoding.class), @XmlElement(name="invalid-authzid", type=InvalidAuthzid.class), @XmlElement(name="invalid-mechanism", type=InvalidMechanism.class), @XmlElement(name="malformed-request", type=MalformedRequest.class), @XmlElement(name="mechanism-too-weak", type=MechanismTooWeak.class), @XmlElement(name="not-authorized", type=NotAuthorized.class), @XmlElement(name="temporary-auth-failure", type=TemporaryAuthFailure.class)})
    private final Condition condition;
    private final Text text;

    private Failure() {
        this.condition = null;
        this.text = null;
    }

    public Failure(Condition condition) {
        this.condition = Objects.requireNonNull(condition);
        this.text = null;
    }

    public Failure(Condition condition, String text, Locale locale) {
        this.condition = Objects.requireNonNull(condition);
        this.text = text != null ? new Text(text, locale) : null;
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public final String getText() {
        if (this.text != null) {
            return this.text.text;
        }
        return null;
    }

    public final Locale getLanguage() {
        if (this.text != null) {
            return this.text.lang;
        }
        return null;
    }

    public final String toString() {
        String text = this.getText();
        return "SASL failure:" + (this.condition != null ? " " + this.condition.toString() : "") + (text != null ? " (" + text + ')' : "");
    }

    private static final class Text {
        @XmlValue
        private final String text;
        @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
        private final Locale lang;

        private Text() {
            this.text = null;
            this.lang = null;
        }

        private Text(String text, Locale lang) {
            this.text = text;
            this.lang = lang;
        }
    }

    @XmlTransient
    public static abstract class Condition {
        public static final Condition ABORTED = new Aborted();
        public static final Condition ACCOUNT_DISABLED = new AccountDisabled();
        public static final Condition CREDENTIALS_EXPIRED = new CredentialsExpired();
        public static final Condition ENCRYPTION_REQUIRED = new EncryptionRequired();
        public static final Condition INCORRECT_ENCODING = new IncorrectEncoding();
        public static final Condition INVALID_AUTHZID = new InvalidAuthzid();
        public static final Condition INVALID_MECHANISM = new InvalidMechanism();
        public static final Condition MALFORMED_REQUEST = new MalformedRequest();
        public static final Condition MECHANISM_TOO_WEAK = new MechanismTooWeak();
        public static final Condition NOT_AUTHORIZED = new NotAuthorized();
        public static final Condition TEMPORARY_AUTH_FAILURE = new TemporaryAuthFailure();

        private Condition() {
        }

        public final String toString() {
            return this.getClass().getSimpleName().replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase();
        }
    }

    @XmlType(factoryMethod="create")
    static final class TemporaryAuthFailure
    extends Condition {
        private TemporaryAuthFailure() {
        }

        private static TemporaryAuthFailure create() {
            return (TemporaryAuthFailure)TEMPORARY_AUTH_FAILURE;
        }
    }

    @XmlType(factoryMethod="create")
    static final class NotAuthorized
    extends Condition {
        private NotAuthorized() {
        }

        private static NotAuthorized create() {
            return (NotAuthorized)NOT_AUTHORIZED;
        }
    }

    @XmlType(factoryMethod="create")
    static final class MechanismTooWeak
    extends Condition {
        private MechanismTooWeak() {
        }

        private static MechanismTooWeak create() {
            return (MechanismTooWeak)MECHANISM_TOO_WEAK;
        }
    }

    @XmlType(factoryMethod="create")
    static class MalformedRequest
    extends Condition {
        private MalformedRequest() {
        }

        private static MalformedRequest create() {
            return (MalformedRequest)MALFORMED_REQUEST;
        }
    }

    @XmlType(factoryMethod="create")
    static final class InvalidMechanism
    extends Condition {
        private InvalidMechanism() {
        }

        private static InvalidMechanism create() {
            return (InvalidMechanism)INVALID_MECHANISM;
        }
    }

    @XmlType(factoryMethod="create")
    static final class InvalidAuthzid
    extends Condition {
        private InvalidAuthzid() {
        }

        private static InvalidAuthzid create() {
            return (InvalidAuthzid)INVALID_AUTHZID;
        }
    }

    @XmlType(factoryMethod="create")
    static final class IncorrectEncoding
    extends Condition {
        private IncorrectEncoding() {
        }

        private static IncorrectEncoding create() {
            return (IncorrectEncoding)INCORRECT_ENCODING;
        }
    }

    @XmlType(factoryMethod="create")
    static final class EncryptionRequired
    extends Condition {
        private EncryptionRequired() {
        }

        private static EncryptionRequired create() {
            return (EncryptionRequired)ENCRYPTION_REQUIRED;
        }
    }

    @XmlType(factoryMethod="create")
    static final class CredentialsExpired
    extends Condition {
        private CredentialsExpired() {
        }

        private static CredentialsExpired create() {
            return (CredentialsExpired)CREDENTIALS_EXPIRED;
        }
    }

    @XmlType(factoryMethod="create")
    static final class AccountDisabled
    extends Condition {
        private AccountDisabled() {
        }

        private static AccountDisabled create() {
            return (AccountDisabled)ACCOUNT_DISABLED;
        }
    }

    @XmlType(factoryMethod="create")
    static final class Aborted
    extends Condition {
        private Aborted() {
        }

        private static Aborted create() {
            return (Aborted)ABORTED;
        }
    }
}

