/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class PrefixFreeCanonicalizationWriter
implements XMLStreamWriter {
    private static final Collection<String> PREFIXED_NAMESPACES = Arrays.asList("http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/2003/05/soap-envelope");
    private final String contentNamespace;
    private final Deque<String> namespaces = new ArrayDeque<String>();
    private final XMLStreamWriter xsw;
    private final boolean writeStreamNamespace;
    private String defaultNS;

    PrefixFreeCanonicalizationWriter(XMLStreamWriter xsw, String contentNamespace, boolean writeStreamNamespace) {
        this.xsw = xsw;
        this.contentNamespace = contentNamespace == null ? "" : contentNamespace;
        this.defaultNS = this.contentNamespace;
        this.writeStreamNamespace = writeStreamNamespace;
    }

    @Override
    public final void writeStartElement(String localName) throws XMLStreamException {
        this.pushNamespaceUri("");
        this.xsw.writeStartElement(localName);
    }

    @Override
    public final void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.pushNamespaceUri(namespaceURI);
        this.xsw.writeStartElement(namespaceURI, localName);
    }

    @Override
    public final void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.pushNamespaceUri(namespaceURI);
        if (this.shouldWriteNamespacePrefix(namespaceURI)) {
            this.xsw.writeStartElement(prefix, localName, namespaceURI);
        } else {
            this.xsw.writeStartElement("", localName, namespaceURI);
            this.writeDefaultNamespaceIfNecessary(namespaceURI);
        }
    }

    @Override
    public final void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.pushNamespaceUri(namespaceURI);
        this.xsw.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public final void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.pushNamespaceUri(namespaceURI);
        if (this.shouldWriteNamespacePrefix(namespaceURI)) {
            this.xsw.writeEmptyElement(prefix, localName, namespaceURI);
        } else {
            this.xsw.writeEmptyElement(namespaceURI, localName);
            this.writeDefaultNamespaceIfNecessary(namespaceURI);
        }
    }

    private void writeDefaultNamespaceIfNecessary(String namespaceURI) throws XMLStreamException {
        if (namespaceURI != null && !"".equals(namespaceURI) && !this.defaultNS.equals(namespaceURI)) {
            this.xsw.writeDefaultNamespace(namespaceURI);
            this.defaultNS = namespaceURI;
        }
    }

    @Override
    public final void writeEmptyElement(String localName) throws XMLStreamException {
        this.xsw.writeEmptyElement(localName);
    }

    @Override
    public final void writeEndElement() throws XMLStreamException {
        this.xsw.writeEndElement();
        this.popNamespaceUri();
    }

    @Override
    public final void writeEndDocument() throws XMLStreamException {
        this.xsw.writeEndDocument();
    }

    @Override
    public final void close() throws XMLStreamException {
        this.xsw.close();
    }

    @Override
    public final void flush() throws XMLStreamException {
        this.xsw.flush();
    }

    @Override
    public final void writeAttribute(String localName, String value) throws XMLStreamException {
        this.xsw.writeAttribute(localName, value);
    }

    @Override
    public final void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (!"http://www.w3.org/XML/1998/namespace".equals(namespaceURI) && this.getNamespaceContext().getPrefix(namespaceURI) == null) {
            this.xsw.writeNamespace(prefix, namespaceURI);
        }
        this.xsw.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public final void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.xsw.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public final void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.shouldWriteNamespace(namespaceURI)) {
            this.xsw.writeNamespace(prefix, namespaceURI);
        }
    }

    @Override
    public final void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.xsw.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public final void writeComment(String data) throws XMLStreamException {
        this.xsw.writeComment(data);
    }

    @Override
    public final void writeProcessingInstruction(String target) throws XMLStreamException {
        this.xsw.writeProcessingInstruction(target);
    }

    @Override
    public final void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.xsw.writeProcessingInstruction(target, data);
    }

    @Override
    public final void writeCData(String data) throws XMLStreamException {
        this.xsw.writeCData(data);
    }

    @Override
    public final void writeDTD(String dtd) throws XMLStreamException {
        this.xsw.writeDTD(dtd);
    }

    @Override
    public final void writeEntityRef(String name) throws XMLStreamException {
        this.xsw.writeEntityRef(name);
    }

    @Override
    public final void writeStartDocument() throws XMLStreamException {
        this.xsw.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.xsw.writeStartDocument(version);
    }

    @Override
    public final void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.xsw.writeStartDocument(encoding, version);
    }

    @Override
    public final void writeCharacters(String text) throws XMLStreamException {
        this.xsw.writeCharacters(text);
    }

    @Override
    public final void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.xsw.writeCharacters(text, start, len);
    }

    @Override
    public final String getPrefix(String uri) throws XMLStreamException {
        return this.xsw.getPrefix(uri);
    }

    @Override
    public final void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.xsw.setPrefix(prefix, uri);
    }

    @Override
    public final void setDefaultNamespace(String uri) throws XMLStreamException {
        this.xsw.setDefaultNamespace(uri);
    }

    @Override
    public final NamespaceContext getNamespaceContext() {
        return this.xsw.getNamespaceContext();
    }

    @Override
    public final void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.xsw.setNamespaceContext(context);
    }

    @Override
    public final Object getProperty(String name) throws IllegalArgumentException {
        return this.xsw.getProperty(name);
    }

    private void pushNamespaceUri(String namespaceUri) {
        this.namespaces.addFirst(namespaceUri);
    }

    private void popNamespaceUri() {
        this.namespaces.removeFirst();
        this.defaultNS = !this.namespaces.isEmpty() ? this.namespaces.peekFirst() : this.contentNamespace;
    }

    private boolean shouldWriteNamespace(String namespaceURI) {
        return !Collections.disjoint(this.namespaces, PREFIXED_NAMESPACES) || "http://etherx.jabber.org/streams".equals(namespaceURI) && this.writeStreamNamespace;
    }

    private boolean shouldWriteNamespacePrefix(String namespaceURI) {
        return this.shouldWriteNamespace(namespaceURI) || "http://etherx.jabber.org/streams".equals(namespaceURI);
    }
}

