/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.ExtensibleStanza;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.Text;
import rocks.xmpp.core.stanza.model.errors.Condition;

@XmlTransient
public class Presence
extends ExtensibleStanza
implements Comparable<Presence> {
    private final List<Text> status = new CopyOnWriteArrayList<Text>();
    private Byte priority;
    private Show show;
    @XmlAttribute
    private Type type;

    public Presence() {
        super(null, null, null, null, null, null);
        this.priority = null;
        this.show = null;
        this.type = null;
    }

    public Presence(Byte priority) {
        this(null, null, null, null, priority, null, null, null, null, null);
    }

    public Presence(Show show) {
        this(show, null);
    }

    public Presence(Show show, Byte priority) {
        this(null, null, show, null, priority, null, null, null, null, null);
    }

    public Presence(Type type) {
        this(type, null);
    }

    public Presence(Type type, Byte priority) {
        this(null, type, null, null, priority, null, null, null, null, null);
    }

    public Presence(Jid to) {
        this(to, null, null, null);
    }

    public Presence(Jid to, Show show, String status) {
        this(to, null, show, status != null ? Collections.singleton(new Text(status)) : null, null, null, null, null, null, null);
    }

    public Presence(Jid to, Type type, String status) {
        this(to, type, status, null);
    }

    public Presence(Jid to, Type type, String status, String id) {
        this(to, type, null, status != null ? Collections.singleton(new Text(status)) : null, null, id, null, null, null, null);
    }

    public Presence(Jid to, Type type, Show show, Collection<Text> status, Byte priority, String id, Jid from, Locale language, Collection<?> extensions, StanzaError error) {
        super(to, from, id, language, extensions, error);
        this.show = show;
        this.type = type;
        if (status != null) {
            this.status.addAll(status);
        }
        this.priority = priority;
    }

    public final synchronized boolean isAvailable() {
        return this.type == null;
    }

    public final synchronized Show getShow() {
        return this.show;
    }

    public final synchronized void setShow(Show show) {
        this.show = show;
    }

    public final synchronized Byte getPriority() {
        return this.priority;
    }

    public final synchronized void setPriority(byte priority) {
        this.priority = priority;
    }

    public final synchronized Type getType() {
        return this.type;
    }

    public final synchronized void setType(Type type) {
        this.type = type;
    }

    public final List<Text> getStatuses() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getStatus() {
        for (Text status : this.status) {
            if (status.getLanguage() != null) continue;
            return status.getText();
        }
        Presence presence = this;
        synchronized (presence) {
            if (!this.status.isEmpty()) {
                return this.status.get(0).getText();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setStatus(String text) {
        if (text != null) {
            Presence presence = this;
            synchronized (presence) {
                for (Text s : this.status) {
                    if (s.getLanguage() != null) continue;
                    this.status.remove(s);
                    break;
                }
                this.status.add(0, new Text(text));
            }
        } else {
            this.status.clear();
        }
    }

    @Override
    public final Presence createError(StanzaError error) {
        return new Presence(this.getTo(), Type.ERROR, this.getShow(), this.getStatuses(), this.getPriority(), this.getId(), this.getFrom(), this.getLanguage(), this.getExtensions(), error);
    }

    @Override
    public final Presence createError(Condition condition) {
        return this.createError(new StanzaError(condition));
    }

    @Override
    public final synchronized int compareTo(Presence o) {
        if (o == null) {
            return -1;
        }
        if (this.isAvailable() && !o.isAvailable()) {
            return -1;
        }
        if (!this.isAvailable() && o.isAvailable()) {
            return 1;
        }
        int result = Byte.compare(this.priority != null ? this.priority : (byte)0, o.priority != null ? o.priority : (byte)0);
        if (result == 0) {
            if (this.show == null && o.show != null) {
                return -1;
            }
            if (this.show == null) {
                return 0;
            }
            if (o.show == null) {
                return 1;
            }
            return this.show.compareTo(o.show);
        }
        return result;
    }

    @Override
    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            String sType = this.type.name();
            sb.append(sType.substring(0, 1)).append(sType.substring(1).toLowerCase()).append(' ');
        }
        sb.append("Presence");
        if (this.show != null) {
            sb.append(' ').append(this.show.name());
        }
        sb.append(super.toString());
        String status = this.getStatus();
        if (status != null) {
            sb.append(": ").append(status);
        }
        return sb.toString();
    }

    @XmlType(name="presenceType")
    public static enum Type {
        ERROR,
        PROBE,
        SUBSCRIBE,
        SUBSCRIBED,
        UNAVAILABLE,
        UNSUBSCRIBE,
        UNSUBSCRIBED;

    }

    public static enum Show {
        CHAT,
        AWAY,
        XA,
        DND;

    }
}

