/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.data.model;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.extensions.data.layout.model.Page;
import rocks.xmpp.extensions.data.mediaelement.model.Media;
import rocks.xmpp.extensions.data.validate.model.Validation;

@XmlRootElement(name="x")
public final class DataForm
implements Comparable<DataForm> {
    public static final String NAMESPACE = "jabber:x:data";
    public static final String FORM_TYPE = "FORM_TYPE";
    private final List<String> instructions = new ArrayList<String>();
    @XmlElementRef
    private final List<Page> pages = new ArrayList<Page>();
    private final List<Field> field = new ArrayList<Field>();
    private final List<Item> item = new ArrayList<Item>();
    @XmlAttribute
    private final Type type;
    private final String title;
    @XmlElementWrapper(name="reported")
    @XmlElement(name="field")
    private final List<Field> reportedFields;

    private DataForm() {
        this.type = null;
        this.title = null;
        this.reportedFields = null;
    }

    public DataForm(Type type) {
        this(type, null);
    }

    public DataForm(Type type, Collection<Field> fields) {
        this.type = Objects.requireNonNull(type);
        this.title = null;
        this.reportedFields = null;
        if (fields != null) {
            this.field.addAll(fields);
        }
    }

    public DataForm(Builder<? extends Builder> builder) {
        if (((Builder)builder).formType != null) {
            this.field.add(Field.builder().var(FORM_TYPE).value(((Builder)builder).formType).type(Field.Type.HIDDEN).build());
        }
        this.field.addAll(((Builder)builder).fields);
        this.type = ((Builder)builder).type;
        this.title = ((Builder)builder).title;
        if (((Builder)builder).items != null) {
            this.item.addAll(((Builder)builder).items);
        }
        if (((Builder)builder).instructions != null) {
            this.instructions.addAll(((Builder)builder).instructions);
        }
        if (((Builder)builder).pages != null) {
            this.pages.addAll(((Builder)builder).pages);
        }
        if (((Builder)builder).reportedFields != null && !((Builder)builder).reportedFields.isEmpty()) {
            this.reportedFields = new ArrayList<Field>();
            this.reportedFields.addAll(((Builder)builder).reportedFields);
        } else {
            this.reportedFields = null;
        }
    }

    public DataForm(Type type, String title, Collection<Field> fields, Collection<Field> reportedFields, Collection<Item> items, Collection<String> instructions, Collection<Page> pages) {
        this.type = type;
        this.title = title;
        if (instructions != null) {
            this.instructions.addAll(instructions);
        }
        if (pages != null) {
            this.pages.addAll(pages);
        }
        if (fields != null) {
            this.field.addAll(fields);
        }
        if (items != null) {
            this.item.addAll(items);
        }
        if (reportedFields != null && !reportedFields.isEmpty()) {
            this.reportedFields = new ArrayList<Field>();
            this.reportedFields.addAll(reportedFields);
        } else {
            this.reportedFields = null;
        }
    }

    private static boolean parseBoolean(String value) {
        return Boolean.parseBoolean(value) || "1".equals(value);
    }

    public final String findValue(String var) {
        List<String> values = this.findValues(var);
        return values.isEmpty() ? null : values.get(0);
    }

    public final List<String> findValues(String var) {
        Field field = this.findField(var);
        return field == null ? Collections.emptyList() : field.getValues();
    }

    public final boolean findValueAsBoolean(String var) {
        return DataForm.parseBoolean(this.findValue(var));
    }

    public final Integer findValueAsInteger(String var) {
        Field field = this.findField(var);
        return field == null ? null : field.getValueAsInteger();
    }

    public final Instant findValueAsInstant(String var) {
        Field field = this.findField(var);
        return field == null ? null : field.getValueAsInstant();
    }

    public final Jid findValueAsJid(String var) {
        Field field = this.findField(var);
        return field == null ? null : field.getValueAsJid();
    }

    public final List<Jid> findValuesAsJid(String var) {
        Field field = this.findField(var);
        return field == null ? Collections.emptyList() : field.getValuesAsJid();
    }

    public final String getFormType() {
        for (Field field : this.getFields()) {
            if (!FORM_TYPE.equals(field.getVar()) || field.getValues().isEmpty()) continue;
            return field.getValues().get(0);
        }
        return null;
    }

    public final String getTitle() {
        return this.title;
    }

    public final List<Field> getFields() {
        return Collections.unmodifiableList(this.field);
    }

    public final List<String> getInstructions() {
        return Collections.unmodifiableList(this.instructions);
    }

    public final Type getType() {
        return this.type;
    }

    public final List<Field> getReportedFields() {
        return Collections.unmodifiableList(this.reportedFields == null ? Collections.emptyList() : this.reportedFields);
    }

    public final List<Item> getItems() {
        return Collections.unmodifiableList(this.item);
    }

    public final List<Page> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    public final Field findField(String name) {
        if (name != null) {
            for (Field field : this.field) {
                if (!name.equals(field.getVar())) continue;
                return field;
            }
        }
        return null;
    }

    @Override
    public final int compareTo(DataForm o) {
        String fto;
        String ft = this.getFormType();
        String string = fto = o != null ? o.getFormType() : null;
        if (ft == null && fto == null) {
            return 0;
        }
        if (ft == null) {
            return 1;
        }
        if (fto == null) {
            return -1;
        }
        return ft.compareTo(fto);
    }

    public static abstract class Builder<T extends Builder<T>> {
        private Collection<Field> fields;
        private Collection<Item> items;
        private String formType;
        private Type type;
        private String title;
        private Collection<String> instructions;
        private Collection<Page> pages;
        private Collection<Field> reportedFields;

        public final T fields(Collection<Field> fields) {
            this.fields = fields;
            return this.self();
        }

        public final T formType(String formType) {
            this.formType = formType;
            return this.self();
        }

        public final T type(Type type) {
            this.type = type;
            return this.self();
        }

        public final T title(String title) {
            this.title = title;
            return this.self();
        }

        public final T instructions(Collection<String> instructions) {
            this.instructions = instructions;
            return this.self();
        }

        public final T pages(Collection<Page> pages) {
            this.pages = pages;
            return this.self();
        }

        public final T items(Collection<Item> items) {
            this.items = items;
            return this.self();
        }

        public final T reportedFields(Collection<Field> reportedFields) {
            this.reportedFields = reportedFields;
            return this.self();
        }

        protected abstract T self();
    }

    public static final class Option {
        @XmlAttribute
        private final String label;
        private final String value;

        private Option() {
            this.value = null;
            this.label = null;
        }

        public Option(String value) {
            this(value, null);
        }

        public Option(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public final String getLabel() {
            return this.label;
        }

        public final String getValue() {
            return this.value;
        }
    }

    public static final class Item {
        private final List<Field> field = new ArrayList<Field>();

        public final List<Field> getFields() {
            return this.field;
        }
    }

    @XmlRootElement
    public static final class Field
    implements Comparable<Field> {
        private final String desc;
        private final String required;
        @XmlElementRef
        private final Validation validation;
        private final List<String> value = new ArrayList<String>();
        private final List<Option> option = new ArrayList<Option>();
        @XmlElementRef
        private final Media media;
        @XmlAttribute
        private final String label;
        @XmlAttribute
        private final Type type;
        @XmlAttribute
        private final String var;

        private Field() {
            this.type = null;
            this.desc = null;
            this.required = null;
            this.validation = null;
            this.media = null;
            this.label = null;
            this.var = null;
        }

        private Field(Builder builder) {
            this.type = builder.type;
            this.desc = builder.description;
            this.required = builder.required ? "" : null;
            this.validation = builder.validation;
            this.value.addAll(builder.values);
            this.option.addAll(builder.options);
            this.media = builder.media;
            this.label = builder.label;
            this.var = builder.var;
        }

        public static Builder builder() {
            return new Builder();
        }

        public final Type getType() {
            return this.type;
        }

        public final String getVar() {
            return this.var;
        }

        public final String getLabel() {
            return this.label;
        }

        public final List<Option> getOptions() {
            return Collections.unmodifiableList(this.option);
        }

        public final List<String> getValues() {
            return Collections.unmodifiableList(this.value);
        }

        public final String getValue() {
            return this.value.isEmpty() ? null : this.value.get(0);
        }

        public final boolean getValueAsBoolean() {
            return DataForm.parseBoolean(this.value.isEmpty() ? null : this.value.get(0));
        }

        public final Integer getValueAsInteger() {
            return this.value.isEmpty() ? null : Integer.valueOf(this.value.get(0));
        }

        public final Instant getValueAsInstant() {
            if (this.value.isEmpty()) {
                return null;
            }
            return this.value.get(0) != null ? Instant.parse(this.value.get(0)) : null;
        }

        public final List<Jid> getValuesAsJid() {
            return Collections.unmodifiableList(this.value.stream().map(Jid::ofEscaped).collect(Collectors.toList()));
        }

        public final Jid getValueAsJid() {
            return this.value.isEmpty() ? null : Jid.ofEscaped((CharSequence)this.value.get(0));
        }

        public final Media getMedia() {
            return this.media;
        }

        public final String getDescription() {
            return this.desc;
        }

        public final Validation getValidation() {
            return this.validation;
        }

        public final boolean isRequired() {
            return this.required != null;
        }

        @Override
        public final int compareTo(Field o) {
            if (DataForm.FORM_TYPE.equals(this.var) && !DataForm.FORM_TYPE.equals(o.var)) {
                return -1;
            }
            if (this.var == null && o.var == null) {
                return 0;
            }
            if (this.var == null) {
                return -1;
            }
            if (o.var == null) {
                return 1;
            }
            return this.var.compareTo(o.var);
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.var != null) {
                sb.append(this.var);
            }
            if (!this.value.isEmpty()) {
                if (this.var != null) {
                    sb.append(": ");
                }
                if (this.value.size() == 1) {
                    String v = this.value.get(0);
                    if (this.type == Type.BOOLEAN) {
                        sb.append(DataForm.parseBoolean(v));
                    } else {
                        sb.append(v);
                    }
                } else {
                    sb.append(this.value);
                }
            }
            return sb.toString();
        }

        public static final class Builder {
            private final List<String> values = new ArrayList<String>();
            private final List<Option> options = new ArrayList<Option>();
            private Type type;
            private String description;
            private boolean required;
            private Media media;
            private Validation validation;
            private String var;
            private String label;

            private Builder() {
            }

            public final Builder type(Type type) {
                this.type = type;
                return this;
            }

            public final Builder required(boolean required) {
                this.required = required;
                return this;
            }

            public final Builder description(String description) {
                this.description = description;
                return this;
            }

            public final Builder media(Media media) {
                this.media = media;
                return this;
            }

            public final Builder validation(Validation validation) {
                this.validation = validation;
                return this;
            }

            public final Builder label(String label) {
                this.label = label;
                return this;
            }

            public final Builder var(String var) {
                this.var = var;
                return this;
            }

            public final Builder value(String value) {
                this.values.clear();
                if (value != null) {
                    this.values.add(value);
                }
                return this.type(Type.TEXT_SINGLE);
            }

            public final Builder value(boolean value) {
                this.value(value ? "1" : "0");
                return this.type(Type.BOOLEAN);
            }

            public final Builder value(int value) {
                this.value(String.valueOf(value));
                return this.type(Type.TEXT_SINGLE);
            }

            public final Builder value(Jid value) {
                if (value != null) {
                    this.value(value.toEscapedString());
                }
                return this.type(Type.JID_SINGLE);
            }

            public final Builder value(Instant instant) {
                if (instant != null) {
                    this.value(instant.toString());
                }
                return this.type(Type.TEXT_SINGLE);
            }

            public final Builder values(Collection<String> values) {
                this.values.clear();
                if (values != null) {
                    this.values.addAll(values);
                }
                return this.type(Type.TEXT_MULTI);
            }

            public final Builder valuesEnum(Collection<? extends Enum<?>> values) {
                this.values.clear();
                this.values.addAll(values.stream().map(enumValue -> enumValue.name().toLowerCase()).collect(Collectors.toList()));
                return this.type(Type.LIST_SINGLE);
            }

            public final Builder valuesJid(Collection<Jid> values) {
                this.values.clear();
                if (values != null) {
                    this.values.addAll(values.stream().map(Jid::toEscapedString).collect(Collectors.toList()));
                }
                return this.type(Type.JID_MULTI);
            }

            public final Builder options(Collection<Option> options) {
                this.options.clear();
                this.options.addAll(options);
                return this;
            }

            public final Field build() {
                return new Field(this);
            }
        }

        @XmlType(name="field-type")
        public static enum Type {
            BOOLEAN,
            FIXED,
            HIDDEN,
            JID_MULTI,
            JID_SINGLE,
            LIST_MULTI,
            LIST_SINGLE,
            TEXT_MULTI,
            TEXT_PRIVATE,
            TEXT_SINGLE;

        }
    }

    @XmlEnum
    @XmlType(name="form-type")
    public static enum Type {
        CANCEL,
        FORM,
        RESULT,
        SUBMIT;

    }
}

