/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.debug.gui;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.debug.gui.DebugViewModel;
import rocks.xmpp.debug.gui.IQContextMenu;
import rocks.xmpp.debug.gui.StanzaEntry;

public final class DebugController
implements Initializable {
    private static final String CSS_INCOMING_STANZA = "incoming-stanza";
    private static final String CSS_OUTGOING_STANZA = "outgoing-stanza";
    private static final String CSS_ERROR_STANZA = "error-stanza";
    private static final String CSS_HIGHLIGHT_ROW = "highlight-row";
    private static final String CSS_PRESENCE = "presence";
    private static final String CSS_AVAILABLE = "available";
    private static final String CSS_UNAVAILABLE = "unavailable";
    private static final String CSS_AWAY = "away";
    final DebugViewModel viewModel = new DebugViewModel();
    private final Transformer transformer;
    private final SAXParser parser;
    @FXML
    private Text lblStatus;
    @FXML
    private Text lblServer;
    @FXML
    private Text lblPort;
    @FXML
    private Circle circlePresence;
    private FilteredList<StanzaEntry> filteredList;
    @FXML
    private CheckBox cbIgnoreCase;
    @FXML
    private TextField searchField;
    @FXML
    private CheckBox cbIncoming;
    @FXML
    private CheckBox cbOutgoing;
    @FXML
    private TextArea stanzaView;
    @FXML
    private TextArea txtOutgoing;
    @FXML
    private TextArea txtIncoming;
    @FXML
    private TableView<StanzaEntry> stanzaTableView;
    @FXML
    private TableColumn<StanzaEntry, Boolean> columnIncoming;
    @FXML
    private TableColumn<StanzaEntry, Date> columnDate;
    @FXML
    private TableColumn<StanzaEntry, String> columnStanza;
    @FXML
    private TableColumn<StanzaEntry, Jid> columnFrom;
    @FXML
    private TableColumn<StanzaEntry, Jid> columnTo;

    public DebugController() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            this.parser = parserFactory.newSAXParser();
            this.parser.getXMLReader().setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            this.transformer = transformerFactory.newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("encoding", "UTF-8");
            this.transformer.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException exception) throws TransformerException {
                    throw exception;
                }

                @Override
                public void error(TransformerException exception) throws TransformerException {
                    throw exception;
                }

                @Override
                public void fatalError(TransformerException exception) throws TransformerException {
                    throw exception;
                }
            });
        }
        catch (ParserConfigurationException | TransformerConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean containsIgnoreCase(String src, String input) {
        int length = input.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(input.charAt(0));
        char firstUp = Character.toUpperCase(input.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, input, 0, length)) continue;
            return true;
        }
        return false;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.lblServer.textProperty().bind((ObservableValue)this.viewModel.server);
        this.lblPort.textProperty().bind((ObservableValue)new StringBinding(){

            protected String computeValue() {
                return DebugController.this.viewModel.port.getValue() != null ? Integer.toString(DebugController.this.viewModel.port.get()) : "";
            }
        });
        this.lblStatus.textProperty().bind((ObservableValue)new StringBinding(){

            protected String computeValue() {
                return DebugController.this.viewModel.status.getValue() != null ? ((XmppSession.Status)DebugController.this.viewModel.status.getValue()).name().toLowerCase() : "";
            }
        });
        this.circlePresence.setRadius(10.0);
        this.circlePresence.getStyleClass().addAll((Object[])new String[]{CSS_PRESENCE, CSS_UNAVAILABLE});
        this.viewModel.presence.addListener((ChangeListener)new ChangeListener<Presence>(){

            public void changed(ObservableValue<? extends Presence> observable, Presence oldValue, Presence newValue) {
                DebugController.this.circlePresence.getStyleClass().removeAll((Object[])new String[]{DebugController.CSS_UNAVAILABLE, DebugController.CSS_AVAILABLE});
                Presence presence = (Presence)DebugController.this.viewModel.presence.get();
                if (presence != null) {
                    if (presence.isAvailable()) {
                        if (presence.getShow() != null) {
                            switch (presence.getShow()) {
                                case AWAY: {
                                    DebugController.this.circlePresence.getStyleClass().add((Object)DebugController.CSS_AWAY);
                                    break;
                                }
                                default: {
                                    DebugController.this.circlePresence.getStyleClass().add((Object)DebugController.CSS_AVAILABLE);
                                    break;
                                }
                            }
                        } else {
                            DebugController.this.circlePresence.getStyleClass().add((Object)DebugController.CSS_AVAILABLE);
                        }
                    } else {
                        DebugController.this.circlePresence.getStyleClass().add((Object)DebugController.CSS_UNAVAILABLE);
                    }
                } else {
                    DebugController.this.circlePresence.getStyleClass().add((Object)DebugController.CSS_UNAVAILABLE);
                }
            }
        });
        this.filteredList = new FilteredList(this.viewModel.stanzas, (Predicate)new Predicate<StanzaEntry>(){

            @Override
            public boolean test(StanzaEntry stanzaEntry) {
                return DebugController.this.isVisible(stanzaEntry);
            }
        });
        this.searchField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                DebugController.this.filter();
            }
        });
        SortedList sortedList = new SortedList(this.filteredList);
        this.stanzaTableView.setItems((ObservableList)sortedList);
        sortedList.comparatorProperty().bind((ObservableValue)this.stanzaTableView.comparatorProperty());
        this.stanzaTableView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<StanzaEntry>(){

            public void changed(ObservableValue<? extends StanzaEntry> observable, StanzaEntry oldValue, StanzaEntry newValue) {
                DebugController.this.viewModel.highlightedItems.clear();
                DebugController.this.stanzaView.getStyleClass().removeAll((Object[])new String[]{DebugController.CSS_INCOMING_STANZA, DebugController.CSS_OUTGOING_STANZA, DebugController.CSS_ERROR_STANZA});
                if (newValue != null) {
                    if (newValue.isIncoming()) {
                        DebugController.this.stanzaView.getStyleClass().add((Object)DebugController.CSS_INCOMING_STANZA);
                    } else {
                        DebugController.this.stanzaView.getStyleClass().add((Object)DebugController.CSS_OUTGOING_STANZA);
                    }
                    try {
                        if (newValue.getStanza() != null) {
                            StreamResult result = new StreamResult(new StringWriter());
                            SAXSource source = new SAXSource(DebugController.this.parser.getXMLReader(), new InputSource(new StringReader(newValue.getXml())));
                            DebugController.this.transformer.setOutputProperty("omit-xml-declaration", "yes");
                            DebugController.this.transformer.transform(source, result);
                            DebugController.this.stanzaView.setText(result.getWriter().toString());
                        } else {
                            DebugController.this.stanzaView.setText(newValue.getXml());
                        }
                    }
                    catch (TransformerException | SAXException e) {
                        try {
                            StreamResult result = new StreamResult(new StringWriter());
                            String streamEndTag = "</stream:stream>";
                            SAXSource source = new SAXSource(DebugController.this.parser.getXMLReader(), new InputSource(new StringReader(newValue.getXml() + streamEndTag)));
                            DebugController.this.transformer.setOutputProperty("omit-xml-declaration", "no");
                            DebugController.this.transformer.transform(source, result);
                            String stream = result.getWriter().toString().trim();
                            if (stream.endsWith("/>")) {
                                DebugController.this.stanzaView.setText(stream);
                            } else {
                                DebugController.this.stanzaView.setText(stream.substring(0, stream.length() - 1 - streamEndTag.length()));
                            }
                        }
                        catch (TransformerException | SAXException e1) {
                            DebugController.this.stanzaView.setText(newValue.getXml());
                        }
                    }
                    for (StanzaEntry entry : DebugController.this.stanzaTableView.getItems()) {
                        if (!(newValue.getStanza() instanceof IQ) || !(entry.getStanza() instanceof IQ)) continue;
                        IQ selectedIQ = (IQ)newValue.getStanza();
                        IQ otherIQ = (IQ)entry.getStanza();
                        if (otherIQ.getId() == null || !otherIQ.getId().equals(selectedIQ.getId()) || (!selectedIQ.isRequest() || !otherIQ.isResponse()) && (!selectedIQ.isResponse() || !otherIQ.isRequest())) continue;
                        DebugController.this.viewModel.highlightedItems.add((Object)entry);
                    }
                    ((TableColumn)DebugController.this.stanzaTableView.getColumns().get(0)).setVisible(false);
                    ((TableColumn)DebugController.this.stanzaTableView.getColumns().get(0)).setVisible(true);
                } else {
                    DebugController.this.stanzaView.setText(null);
                }
            }
        });
        this.stanzaTableView.setRowFactory((Callback)new Callback<TableView<StanzaEntry>, TableRow<StanzaEntry>>(){

            public TableRow<StanzaEntry> call(TableView<StanzaEntry> param) {
                return new TableRow<StanzaEntry>(){
                    private final IQContextMenu iqContextMenu;
                    {
                        this.iqContextMenu = new IQContextMenu((TableView<StanzaEntry>)DebugController.this.stanzaTableView);
                    }

                    protected void updateItem(StanzaEntry item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{DebugController.CSS_INCOMING_STANZA, DebugController.CSS_OUTGOING_STANZA, DebugController.CSS_ERROR_STANZA, DebugController.CSS_HIGHLIGHT_ROW});
                        this.setContextMenu(null);
                        if (!empty) {
                            if (item.isError()) {
                                this.getStyleClass().add((Object)DebugController.CSS_ERROR_STANZA);
                            }
                            if (item.isIncoming()) {
                                this.getStyleClass().add((Object)DebugController.CSS_INCOMING_STANZA);
                            } else {
                                this.getStyleClass().add((Object)DebugController.CSS_OUTGOING_STANZA);
                            }
                            if (item.getStanza() instanceof IQ && ((IQ)item.getStanza()).isRequest()) {
                                this.setContextMenu(this.iqContextMenu);
                                this.iqContextMenu.update(item);
                            }
                            if (DebugController.this.viewModel.highlightedItems.contains((Object)item)) {
                                this.getStyleClass().add((Object)DebugController.CSS_HIGHLIGHT_ROW);
                            }
                        }
                    }
                };
            }
        });
        this.columnIncoming.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StanzaEntry, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<StanzaEntry, Boolean> param) {
                return new SimpleObjectProperty((Object)((StanzaEntry)param.getValue()).isIncoming());
            }
        });
        this.columnIncoming.setCellFactory((Callback)new Callback<TableColumn<StanzaEntry, Boolean>, TableCell<StanzaEntry, Boolean>>(){

            public TableCell<StanzaEntry, Boolean> call(TableColumn<StanzaEntry, Boolean> booleanStanzaEntryTableColumn) {
                TableCell<StanzaEntry, Boolean> cell = new TableCell<StanzaEntry, Boolean>(){

                    protected void updateItem(Boolean item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        this.setGraphic(null);
                        if (!empty && item != null) {
                            Region rectangle = new Region();
                            rectangle.setMaxWidth(Double.NEGATIVE_INFINITY);
                            rectangle.setMaxHeight(Double.NEGATIVE_INFINITY);
                            rectangle.setRotate(item != false ? 90.0 : 270.0);
                            rectangle.getStyleClass().add((Object)"arrow");
                            this.setGraphic((Node)rectangle);
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.columnDate.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StanzaEntry, Date>, ObservableValue<Date>>(){

            public ObservableValue<Date> call(TableColumn.CellDataFeatures<StanzaEntry, Date> param) {
                return new SimpleObjectProperty((Object)((StanzaEntry)param.getValue()).getDate());
            }
        });
        this.columnDate.setCellFactory((Callback)new Callback<TableColumn<StanzaEntry, Date>, TableCell<StanzaEntry, Date>>(){

            public TableCell<StanzaEntry, Date> call(TableColumn<StanzaEntry, Date> dateStanzaEntryTableColumn) {
                TableCell<StanzaEntry, Date> cell = new TableCell<StanzaEntry, Date>(){

                    protected void updateItem(Date item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        this.setTooltip(null);
                        if (!empty) {
                            DateFormat timeFormat = DateFormat.getTimeInstance(3);
                            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                            this.setText(timeFormat.format(item));
                            this.setTooltip(new Tooltip(dateFormat.format(item)));
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.columnStanza.setMaxWidth(Double.MAX_VALUE);
        this.columnStanza.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StanzaEntry, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<StanzaEntry, String> param) {
                return new SimpleObjectProperty((Object)((StanzaEntry)param.getValue()).getXml());
            }
        });
        this.columnStanza.setCellFactory((Callback)new Callback<TableColumn<StanzaEntry, String>, TableCell<StanzaEntry, String>>(){

            public TableCell<StanzaEntry, String> call(TableColumn<StanzaEntry, String> columnStanza) {
                TableCell<StanzaEntry, String> cell = new TableCell<StanzaEntry, String>(){

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        this.setTooltip(null);
                        if (!empty) {
                            this.setText(item);
                        }
                    }
                };
                cell.getStyleClass().add((Object)"stanza-cell");
                return cell;
            }
        });
        this.columnFrom.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StanzaEntry, Jid>, ObservableValue<Jid>>(){

            public ObservableValue<Jid> call(TableColumn.CellDataFeatures<StanzaEntry, Jid> param) {
                return new SimpleObjectProperty((Object)((StanzaEntry)param.getValue()).getFrom());
            }
        });
        this.columnFrom.setCellFactory((Callback)new Callback<TableColumn<StanzaEntry, Jid>, TableCell<StanzaEntry, Jid>>(){

            public TableCell<StanzaEntry, Jid> call(TableColumn<StanzaEntry, Jid> columnStanza) {
                return new TableCell<StanzaEntry, Jid>(){

                    protected void updateItem(Jid item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        if (!empty && item != null) {
                            this.setText(item.toString());
                        }
                    }
                };
            }
        });
        this.columnTo.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<StanzaEntry, Jid>, ObservableValue<Jid>>(){

            public ObservableValue<Jid> call(TableColumn.CellDataFeatures<StanzaEntry, Jid> param) {
                return new SimpleObjectProperty((Object)((StanzaEntry)param.getValue()).getTo());
            }
        });
        this.columnTo.setCellFactory((Callback)new Callback<TableColumn<StanzaEntry, Jid>, TableCell<StanzaEntry, Jid>>(){

            public TableCell<StanzaEntry, Jid> call(TableColumn<StanzaEntry, Jid> columnStanza) {
                return new TableCell<StanzaEntry, Jid>(){

                    protected void updateItem(Jid item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        if (!empty && item != null) {
                            this.setText(item.toString());
                        }
                    }
                };
            }
        });
        this.txtIncoming.setText("");
    }

    @FXML
    public void filter() {
        this.filteredList.setPredicate((Predicate)new Predicate<StanzaEntry>(){

            @Override
            public boolean test(StanzaEntry stanzaEntry) {
                return DebugController.this.isVisible(stanzaEntry);
            }
        });
    }

    @FXML
    public void clear() {
        this.viewModel.stanzas.clear();
    }

    void addStanza(StanzaEntry stanzaEntry) {
        this.viewModel.stanzas.add((Object)stanzaEntry);
    }

    private boolean isVisible(StanzaEntry stanzaEntry) {
        return (this.cbIncoming.isSelected() && stanzaEntry.isIncoming() || this.cbOutgoing.isSelected() && !stanzaEntry.isIncoming()) && (this.searchField.getText() == null || this.searchField.getText().equals("") || stanzaEntry.getXml().contains(this.searchField.getText()) && !this.cbIgnoreCase.isSelected() || DebugController.containsIgnoreCase(stanzaEntry.getXml(), this.searchField.getText()) && this.cbIgnoreCase.isSelected());
    }

    void appendTextIncoming(final String s) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DebugController.this.txtIncoming.appendText(s);
            }
        });
    }

    void appendTextOutgoing(final String s) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DebugController.this.txtOutgoing.appendText(s);
            }
        });
    }

    public void clearOutgoing(ActionEvent actionEvent) {
        this.txtOutgoing.clear();
    }

    public void clearIncoming(ActionEvent actionEvent) {
        this.txtIncoming.clear();
    }
}

