/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.debug.gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.swing.SwingUtilities;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.debug.gui.DebugController;
import rocks.xmpp.debug.gui.StanzaEntry;

public final class VisualDebugger
implements XmppDebugger {
    private static final Map<Tab, SessionStatusListener> connectionListenerMap = new HashMap<Tab, SessionStatusListener>();
    private static Stage stage;
    private static TabPane tabPane;
    final StringProperty title = new SimpleStringProperty();
    private DebugController debugController;
    private volatile boolean platformInitialized;
    private ByteArrayOutputStream outputStreamIncoming;
    private ByteArrayOutputStream outputStreamOutgoing;

    public void initialize(final XmppSession xmppSession) {
        final SessionStatusListener connectionListener = new SessionStatusListener(){

            public void sessionStatusChanged(final SessionStatusEvent e) {
                VisualDebugger.this.waitForPlatform();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (e.getStatus() == XmppSession.Status.CONNECTED && xmppSession.getActiveConnection() != null) {
                            ((VisualDebugger)VisualDebugger.this).debugController.viewModel.server.set((Object)xmppSession.getActiveConnection().getHostname());
                            ((VisualDebugger)VisualDebugger.this).debugController.viewModel.port.set(xmppSession.getActiveConnection().getPort());
                            VisualDebugger.this.title.set((Object)xmppSession.getDomain());
                        }
                        if (e.getStatus() == XmppSession.Status.AUTHENTICATED) {
                            VisualDebugger.this.title.set((Object)xmppSession.getConnectedResource().toString());
                        } else {
                            ((VisualDebugger)VisualDebugger.this).debugController.viewModel.presence.set(null);
                        }
                        ((VisualDebugger)VisualDebugger.this).debugController.viewModel.status.set((Object)e.getStatus());
                    }
                });
            }
        };
        xmppSession.addSessionStatusListener(connectionListener);
        final PresenceListener presenceListener = new PresenceListener(){

            public void handle(PresenceEvent e) {
                Presence presence;
                if (!e.isIncoming() && (presence = e.getPresence()).getTo() == null) {
                    VisualDebugger.this.waitForPlatform();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ((VisualDebugger)VisualDebugger.this).debugController.viewModel.presence.set((Object)presence);
                        }
                    });
                }
            }
        };
        xmppSession.addPresenceListener(presenceListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JFXPanel();
                Platform.runLater((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Font.loadFont((String)this.getClass().getResource("Inconsolata.ttf").toExternalForm(), (double)12.0);
                            if (stage == null) {
                                tabPane = new TabPane();
                                Scene scene = new Scene((Parent)tabPane, 800.0, 600.0);
                                scene.getStylesheets().add((Object)this.getClass().getResource("styles.css").toExternalForm());
                                stage = new Stage();
                                stage.setTitle("XMPP Viewer");
                                stage.getIcons().addAll((Object[])new Image[]{new Image(this.getClass().getResource("xmpp.png").toExternalForm())});
                                stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

                                    public void handle(WindowEvent event) {
                                        for (Tab tab : tabPane.getTabs()) {
                                            xmppSession.removeSessionStatusListener((SessionStatusListener)connectionListenerMap.remove(tab));
                                        }
                                        tabPane.getTabs().clear();
                                        stage = null;
                                        tabPane = null;
                                    }
                                });
                                stage.setScene(scene);
                            }
                            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("DebugView.fxml"));
                            TabPane debugView = (TabPane)fxmlLoader.load();
                            VisualDebugger.this.debugController = (DebugController)fxmlLoader.getController();
                            final Tab tab = new Tab(xmppSession.getDomain());
                            tab.setContent((Node)debugView);
                            tab.textProperty().bind((ObservableValue)VisualDebugger.this.title);
                            connectionListenerMap.put(tab, connectionListener);
                            final AnimationTimer animationTimer = new AnimationTimer(){

                                public void handle(long now) {
                                    String outgoing;
                                    String incoming;
                                    if (VisualDebugger.this.outputStreamIncoming != null && !(incoming = VisualDebugger.this.outputStreamIncoming.toString()).isEmpty()) {
                                        VisualDebugger.this.debugController.appendTextIncoming(incoming);
                                        VisualDebugger.this.outputStreamIncoming.reset();
                                    }
                                    if (VisualDebugger.this.outputStreamOutgoing != null && !(outgoing = VisualDebugger.this.outputStreamOutgoing.toString()).isEmpty()) {
                                        VisualDebugger.this.debugController.appendTextOutgoing(outgoing);
                                        VisualDebugger.this.outputStreamOutgoing.reset();
                                    }
                                }
                            };
                            animationTimer.start();
                            tab.setOnClosed((EventHandler)new EventHandler<Event>(){

                                public void handle(Event event) {
                                    xmppSession.removeSessionStatusListener((SessionStatusListener)connectionListenerMap.remove(tab));
                                    xmppSession.removePresenceListener(presenceListener);
                                    animationTimer.stop();
                                }
                            });
                            tabPane.getTabs().add((Object)tab);
                            stage.show();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        VisualDebugger.this.platformInitialized = true;
                        VisualDebugger visualDebugger = VisualDebugger.this;
                        synchronized (visualDebugger) {
                            VisualDebugger.this.notifyAll();
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPlatform() {
        if (!this.platformInitialized) {
            VisualDebugger visualDebugger = this;
            synchronized (visualDebugger) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void writeStanza(final String xml, final Object stanza) {
        String outgoing;
        if (this.outputStreamOutgoing != null) {
            this.outputStreamOutgoing.write(10);
            outgoing = this.outputStreamOutgoing.toString();
            this.outputStreamOutgoing.reset();
        } else {
            outgoing = "";
        }
        this.waitForPlatform();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                VisualDebugger.this.debugController.addStanza(new StanzaEntry(false, xml, stanza));
                if (!outgoing.isEmpty()) {
                    VisualDebugger.this.debugController.appendTextOutgoing(outgoing);
                }
            }
        });
    }

    public void readStanza(final String xml, final Object stanza) {
        String incoming;
        if (this.outputStreamIncoming != null) {
            this.outputStreamIncoming.write(10);
            incoming = this.outputStreamIncoming.toString();
            this.outputStreamIncoming.reset();
        } else {
            incoming = "";
        }
        this.waitForPlatform();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                VisualDebugger.this.debugController.addStanza(new StanzaEntry(true, xml, stanza));
                if (!incoming.isEmpty()) {
                    VisualDebugger.this.debugController.appendTextIncoming(incoming);
                }
            }
        });
    }

    public OutputStream createOutputStream(OutputStream outputStream) {
        this.outputStreamOutgoing = new ByteArrayOutputStream();
        return XmppUtils.createBranchedOutputStream((OutputStream)outputStream, (OutputStream)this.outputStreamOutgoing);
    }

    public InputStream createInputStream(InputStream inputStream) {
        this.outputStreamIncoming = new ByteArrayOutputStream();
        return XmppUtils.createBranchedInputStream((InputStream)inputStream, (OutputStream)this.outputStreamIncoming);
    }
}

