/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.debug.gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javax.swing.SwingUtilities;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.debug.XmppDebugger;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.debug.gui.DebugController;
import rocks.xmpp.debug.gui.LogFormatter;
import rocks.xmpp.debug.gui.StanzaEntry;
import rocks.xmpp.util.XmppUtils;

public final class VisualDebugger
implements XmppDebugger {
    private static final Map<Tab, Consumer<SessionStatusEvent>> CONNECTION_LISTENER_MAP;
    private static final Queue<LogRecord> LOG_RECORDS;
    private static final Formatter FORMATTER;
    private static Stage stage;
    private static TabPane tabPane;
    private static TextArea textArea;
    private static SplitPane root;
    private static volatile boolean platformInitialized;
    final StringProperty title = new SimpleStringProperty();
    private DebugController debugController;
    private ByteArrayOutputStream outputStreamInbound;
    private ByteArrayOutputStream outputStreamOutbound;

    private static void initializeLogging() {
        Handler logHandler = new Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void publish(LogRecord record) {
                Queue queue = LOG_RECORDS;
                synchronized (queue) {
                    int maxLogEntries = 500;
                    if (LOG_RECORDS.size() >= maxLogEntries) {
                        LOG_RECORDS.poll();
                    }
                    LOG_RECORDS.offer(record);
                }
                if (platformInitialized) {
                    Platform.runLater(() -> VisualDebugger.updateTextArea());
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        logHandler.setLevel(Level.FINE);
        Logger logger = Logger.getLogger("rocks.xmpp");
        logger.addHandler(logHandler);
        logger.setLevel(Level.FINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void waitForPlatform() {
        if (platformInitialized) return;
        Class<VisualDebugger> clazz = VisualDebugger.class;
        synchronized (VisualDebugger.class) {
            if (platformInitialized) return;
            try {
                VisualDebugger.class.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateTextArea() {
        Queue<LogRecord> queue = LOG_RECORDS;
        synchronized (queue) {
            textArea.clear();
            for (LogRecord logRecord : LOG_RECORDS) {
                textArea.appendText(FORMATTER.format(logRecord));
            }
        }
    }

    public void initialize(XmppSession xmppSession) {
        SwingUtilities.invokeLater(() -> {
            new JFXPanel();
            platformInitialized = true;
            Class<VisualDebugger> clazz = VisualDebugger.class;
            synchronized (VisualDebugger.class) {
                VisualDebugger.class.notifyAll();
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        });
        Consumer<SessionStatusEvent> connectionListener = e -> {
            VisualDebugger.waitForPlatform();
            Platform.runLater(() -> {
                if (e.getStatus() == XmppSession.Status.CONNECTED && xmppSession.getActiveConnection() != null) {
                    this.debugController.viewModel.server.set((Object)xmppSession.getActiveConnection().getHostname());
                    this.debugController.viewModel.port.set(xmppSession.getActiveConnection().getPort());
                    this.title.set((Object)(xmppSession.getDomain() != null ? xmppSession.getDomain().toString() : "..."));
                }
                if (e.getStatus() == XmppSession.Status.AUTHENTICATED) {
                    this.title.set((Object)xmppSession.getConnectedResource().toString());
                } else {
                    this.debugController.viewModel.presence.set(null);
                }
                this.debugController.viewModel.status.set((Object)e.getStatus());
            });
        };
        xmppSession.addSessionStatusListener(connectionListener);
        Consumer<PresenceEvent> presenceListener = e -> {
            Presence presence = e.getPresence();
            if (presence.getTo() == null) {
                VisualDebugger.waitForPlatform();
                Platform.runLater(() -> this.debugController.viewModel.presence.set((Object)presence));
            }
        };
        xmppSession.addOutboundPresenceListener(presenceListener);
        VisualDebugger.waitForPlatform();
        Platform.runLater(() -> {
            try {
                Font.loadFont((String)this.getClass().getResource("Inconsolata.ttf").toExternalForm(), (double)12.0);
                if (stage == null) {
                    root = new SplitPane();
                    root.setDividerPositions(new double[]{0.8});
                    root.setOrientation(Orientation.VERTICAL);
                    tabPane = new TabPane();
                    textArea = new TextArea();
                    textArea.setEditable(false);
                    root.getItems().addAll((Object[])new Node[]{tabPane, textArea});
                    VisualDebugger.updateTextArea();
                    Scene scene = new Scene((Parent)root, 800.0, 600.0);
                    scene.getStylesheets().add((Object)this.getClass().getResource("styles.css").toExternalForm());
                    stage = new Stage();
                    stage.setTitle("XMPP Viewer");
                    stage.getIcons().addAll((Object[])new Image[]{new Image(this.getClass().getResource("xmpp.png").toExternalForm())});
                    stage.setOnHidden(event -> {
                        for (Tab tab : tabPane.getTabs()) {
                            xmppSession.removeSessionStatusListener(CONNECTION_LISTENER_MAP.remove(tab));
                        }
                        tabPane.getTabs().clear();
                        stage = null;
                        tabPane = null;
                    });
                    stage.setScene(scene);
                }
                FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("DebugView.fxml"));
                TabPane debugView = (TabPane)fxmlLoader.load();
                this.debugController = (DebugController)fxmlLoader.getController();
                Tab tab = new Tab(xmppSession.getDomain() != null ? xmppSession.getDomain().toString() : "...");
                tab.setContent((Node)debugView);
                tab.textProperty().bind((ObservableValue)this.title);
                CONNECTION_LISTENER_MAP.put(tab, connectionListener);
                AnimationTimer animationTimer = new AnimationTimer(){

                    public void handle(long now) {
                        String outbound;
                        String inbound;
                        if (VisualDebugger.this.outputStreamInbound != null && !(inbound = VisualDebugger.this.outputStreamInbound.toString()).isEmpty()) {
                            VisualDebugger.this.debugController.appendTextInbound(inbound);
                            VisualDebugger.this.outputStreamInbound.reset();
                        }
                        if (VisualDebugger.this.outputStreamOutbound != null && !(outbound = VisualDebugger.this.outputStreamOutbound.toString()).isEmpty()) {
                            VisualDebugger.this.debugController.appendTextOutbound(outbound);
                            VisualDebugger.this.outputStreamOutbound.reset();
                        }
                    }
                };
                animationTimer.start();
                tab.setOnClosed(event -> {
                    xmppSession.removeSessionStatusListener(CONNECTION_LISTENER_MAP.remove(tab));
                    xmppSession.removeOutboundPresenceListener(presenceListener);
                    animationTimer.stop();
                });
                tabPane.getTabs().add((Object)tab);
                stage.show();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void writeStanza(String xml, Object stanza) {
        String outbound;
        if (this.outputStreamOutbound != null) {
            this.outputStreamOutbound.write(10);
            outbound = this.outputStreamOutbound.toString();
            this.outputStreamOutbound.reset();
        } else {
            outbound = "";
        }
        VisualDebugger.waitForPlatform();
        Platform.runLater(() -> {
            this.debugController.addStanza(new StanzaEntry(false, xml, stanza));
            if (!outbound.isEmpty()) {
                this.debugController.appendTextOutbound(outbound);
            }
        });
    }

    public void readStanza(String xml, Object stanza) {
        String inbound;
        if (this.outputStreamInbound != null) {
            this.outputStreamInbound.write(10);
            inbound = this.outputStreamInbound.toString();
            this.outputStreamInbound.reset();
        } else {
            inbound = "";
        }
        VisualDebugger.waitForPlatform();
        Platform.runLater(() -> {
            this.debugController.addStanza(new StanzaEntry(true, xml, stanza));
            if (!inbound.isEmpty()) {
                this.debugController.appendTextInbound(inbound);
            }
        });
    }

    public OutputStream createOutputStream(OutputStream outputStream) {
        this.outputStreamOutbound = new ByteArrayOutputStream();
        return XmppUtils.createBranchedOutputStream((OutputStream)outputStream, (OutputStream)this.outputStreamOutbound);
    }

    public InputStream createInputStream(InputStream inputStream) {
        this.outputStreamInbound = new ByteArrayOutputStream();
        return XmppUtils.createBranchedInputStream((InputStream)inputStream, (OutputStream)this.outputStreamInbound);
    }

    static {
        VisualDebugger.initializeLogging();
        CONNECTION_LISTENER_MAP = new HashMap<Tab, Consumer<SessionStatusEvent>>();
        LOG_RECORDS = new ArrayDeque<LogRecord>();
        FORMATTER = new LogFormatter();
    }
}

