/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.debug.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javax.xml.bind.DataBindingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.debug.gui.DebugViewModel;
import rocks.xmpp.debug.gui.IQContextMenu;
import rocks.xmpp.debug.gui.StanzaEntry;

public final class DebugController
implements Initializable {
    private static final String CSS_INBOUND_STANZA = "inbound-stanza";
    private static final String CSS_OUTBOUND_STANZA = "outbound-stanza";
    private static final String CSS_ERROR_STANZA = "error-stanza";
    private static final String CSS_HIGHLIGHT_ROW = "highlight-row";
    private static final String CSS_PRESENCE = "presence";
    private static final String CSS_AVAILABLE = "available";
    private static final String CSS_UNAVAILABLE = "unavailable";
    private static final String CSS_AWAY = "away";
    final DebugViewModel viewModel = new DebugViewModel();
    private final Transformer transformer;
    private final SAXParser parser;
    private FilteredList<StanzaEntry> filteredList;
    @FXML
    private Text lblStatus;
    @FXML
    private Text lblServer;
    @FXML
    private Text lblPort;
    @FXML
    private Circle circlePresence;
    @FXML
    private CheckBox cbIgnoreCase;
    @FXML
    private TextField searchField;
    @FXML
    private CheckBox cbInbound;
    @FXML
    private CheckBox cbOutbound;
    @FXML
    private TextArea stanzaView;
    @FXML
    private TextArea txtOutbound;
    @FXML
    private TextArea txtInbound;
    @FXML
    private TableView<StanzaEntry> stanzaTableView;
    @FXML
    private TableColumn<StanzaEntry, Boolean> columnInbound;
    @FXML
    private TableColumn<StanzaEntry, LocalDateTime> columnDate;
    @FXML
    private TableColumn<StanzaEntry, String> columnStanza;
    @FXML
    private TableColumn<StanzaEntry, Jid> columnFrom;
    @FXML
    private TableColumn<StanzaEntry, Jid> columnTo;

    public DebugController() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            this.parser = parserFactory.newSAXParser();
            this.parser.getXMLReader().setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            this.transformer = transformerFactory.newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("encoding", "UTF-8");
            this.transformer.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException exception) throws TransformerException {
                    throw exception;
                }

                @Override
                public void error(TransformerException exception) throws TransformerException {
                    throw exception;
                }

                @Override
                public void fatalError(TransformerException exception) throws TransformerException {
                    throw exception;
                }
            });
        }
        catch (ParserConfigurationException | TransformerConfigurationException | SAXException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    private static boolean containsIgnoreCase(String src, String input) {
        int length = input.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(input.charAt(0));
        char firstUp = Character.toUpperCase(input.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, input, 0, length)) continue;
            return true;
        }
        return false;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.lblServer.textProperty().bind((ObservableValue)this.viewModel.server);
        this.lblPort.textProperty().bind((ObservableValue)new StringBinding(){

            protected String computeValue() {
                return DebugController.this.viewModel.port.getValue() != null ? Integer.toString(DebugController.this.viewModel.port.get()) : "";
            }
        });
        this.lblStatus.textProperty().bind((ObservableValue)new StringBinding(){

            protected String computeValue() {
                return DebugController.this.viewModel.status.getValue() != null ? ((XmppSession.Status)DebugController.this.viewModel.status.getValue()).name().toLowerCase() : "";
            }
        });
        this.circlePresence.setRadius(10.0);
        this.circlePresence.getStyleClass().addAll((Object[])new String[]{CSS_PRESENCE, CSS_UNAVAILABLE});
        this.viewModel.presence.addListener((observable, oldValue, newValue) -> {
            this.circlePresence.getStyleClass().removeAll((Object[])new String[]{CSS_UNAVAILABLE, CSS_AVAILABLE});
            Presence presence = (Presence)this.viewModel.presence.get();
            if (presence != null) {
                if (presence.isAvailable()) {
                    if (presence.getShow() != null) {
                        switch (presence.getShow()) {
                            case AWAY: {
                                this.circlePresence.getStyleClass().add((Object)CSS_AWAY);
                                break;
                            }
                            default: {
                                this.circlePresence.getStyleClass().add((Object)CSS_AVAILABLE);
                                break;
                            }
                        }
                    } else {
                        this.circlePresence.getStyleClass().add((Object)CSS_AVAILABLE);
                    }
                } else {
                    this.circlePresence.getStyleClass().add((Object)CSS_UNAVAILABLE);
                }
            } else {
                this.circlePresence.getStyleClass().add((Object)CSS_UNAVAILABLE);
            }
        });
        this.filteredList = new FilteredList(this.viewModel.stanzas, this::isVisible);
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> this.filter());
        SortedList sortedList = new SortedList(this.filteredList);
        this.stanzaTableView.setItems((ObservableList)sortedList);
        sortedList.comparatorProperty().bind((ObservableValue)this.stanzaTableView.comparatorProperty());
        this.stanzaTableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.viewModel.highlightedItems.clear();
            this.stanzaView.getStyleClass().removeAll((Object[])new String[]{CSS_INBOUND_STANZA, CSS_OUTBOUND_STANZA, CSS_ERROR_STANZA});
            if (newValue != null) {
                if (newValue.isInbound()) {
                    this.stanzaView.getStyleClass().add((Object)CSS_INBOUND_STANZA);
                } else {
                    this.stanzaView.getStyleClass().add((Object)CSS_OUTBOUND_STANZA);
                }
                try {
                    if (newValue.getStanza() != null) {
                        StreamResult result = new StreamResult(new StringWriter());
                        SAXSource source = new SAXSource(this.parser.getXMLReader(), new InputSource(new StringReader(newValue.getXml())));
                        this.transformer.setOutputProperty("omit-xml-declaration", "yes");
                        this.transformer.transform(source, result);
                        this.stanzaView.setText(result.getWriter().toString());
                    } else {
                        this.stanzaView.setText(newValue.getXml());
                    }
                }
                catch (TransformerException | SAXException e) {
                    try {
                        StreamResult result = new StreamResult(new StringWriter());
                        String streamEndTag = "</stream:stream>";
                        SAXSource source = new SAXSource(this.parser.getXMLReader(), new InputSource(new StringReader(newValue.getXml() + streamEndTag)));
                        this.transformer.setOutputProperty("omit-xml-declaration", "no");
                        this.transformer.transform(source, result);
                        String stream = result.getWriter().toString().trim();
                        if (stream.endsWith("/>")) {
                            this.stanzaView.setText(stream);
                        } else {
                            this.stanzaView.setText(stream.substring(0, stream.length() - 1 - streamEndTag.length()));
                        }
                    }
                    catch (TransformerException | SAXException e1) {
                        this.stanzaView.setText(newValue.getXml());
                    }
                }
                this.stanzaTableView.getItems().stream().filter(entry -> newValue.getStanza() instanceof IQ && entry.getStanza() instanceof IQ).forEach(entry -> {
                    IQ selectedIQ = (IQ)newValue.getStanza();
                    IQ otherIQ = (IQ)entry.getStanza();
                    if (otherIQ.getId() != null && otherIQ.getId().equals(selectedIQ.getId()) && (selectedIQ.isRequest() && otherIQ.isResponse() || selectedIQ.isResponse() && otherIQ.isRequest()) && newValue.isInbound() != entry.isInbound()) {
                        this.viewModel.highlightedItems.add(entry);
                    }
                });
                ((TableColumn)this.stanzaTableView.getColumns().get(0)).setVisible(false);
                ((TableColumn)this.stanzaTableView.getColumns().get(0)).setVisible(true);
            } else {
                this.stanzaView.setText(null);
            }
        });
        this.stanzaTableView.setRowFactory((Callback)new Callback<TableView<StanzaEntry>, TableRow<StanzaEntry>>(){

            public TableRow<StanzaEntry> call(TableView<StanzaEntry> param) {
                return new TableRow<StanzaEntry>(){
                    private final IQContextMenu iqContextMenu;
                    {
                        this.iqContextMenu = new IQContextMenu((TableView<StanzaEntry>)DebugController.this.stanzaTableView);
                    }

                    protected void updateItem(StanzaEntry item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{DebugController.CSS_INBOUND_STANZA, DebugController.CSS_OUTBOUND_STANZA, DebugController.CSS_ERROR_STANZA, DebugController.CSS_HIGHLIGHT_ROW});
                        this.setContextMenu(null);
                        if (!empty) {
                            if (item.isError()) {
                                this.getStyleClass().add((Object)DebugController.CSS_ERROR_STANZA);
                            }
                            if (item.isInbound()) {
                                this.getStyleClass().add((Object)DebugController.CSS_INBOUND_STANZA);
                            } else {
                                this.getStyleClass().add((Object)DebugController.CSS_OUTBOUND_STANZA);
                            }
                            if (item.getStanza() instanceof IQ && ((IQ)item.getStanza()).isRequest()) {
                                this.setContextMenu(this.iqContextMenu);
                                this.iqContextMenu.update(item);
                            }
                            if (DebugController.this.viewModel.highlightedItems.contains((Object)item)) {
                                this.getStyleClass().add((Object)DebugController.CSS_HIGHLIGHT_ROW);
                            }
                        }
                    }
                };
            }
        });
        this.columnInbound.setCellValueFactory(param -> new SimpleObjectProperty((Object)((StanzaEntry)param.getValue()).isInbound()));
        this.columnInbound.setCellFactory((Callback)new Callback<TableColumn<StanzaEntry, Boolean>, TableCell<StanzaEntry, Boolean>>(){

            public TableCell<StanzaEntry, Boolean> call(TableColumn<StanzaEntry, Boolean> booleanStanzaEntryTableColumn) {
                TableCell<StanzaEntry, Boolean> cell = new TableCell<StanzaEntry, Boolean>(){

                    protected void updateItem(Boolean item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        this.setGraphic(null);
                        if (!empty && item != null) {
                            Region rectangle = new Region();
                            rectangle.setMaxWidth(Double.NEGATIVE_INFINITY);
                            rectangle.setMaxHeight(Double.NEGATIVE_INFINITY);
                            rectangle.setRotate(item != false ? 90.0 : 270.0);
                            rectangle.getStyleClass().add((Object)"arrow");
                            this.setGraphic((Node)rectangle);
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.columnDate.setCellValueFactory(param -> new SimpleObjectProperty((Object)((StanzaEntry)param.getValue()).getDate()));
        this.columnDate.setCellFactory((Callback)new Callback<TableColumn<StanzaEntry, LocalDateTime>, TableCell<StanzaEntry, LocalDateTime>>(){

            public TableCell<StanzaEntry, LocalDateTime> call(TableColumn<StanzaEntry, LocalDateTime> dateStanzaEntryTableColumn) {
                TableCell<StanzaEntry, LocalDateTime> cell = new TableCell<StanzaEntry, LocalDateTime>(){

                    protected void updateItem(LocalDateTime item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        this.setTooltip(null);
                        if (!empty) {
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
                            String formatted = formatter.format(item);
                            this.setText(formatted);
                            this.setTooltip(new Tooltip(formatted));
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.columnStanza.setMaxWidth(Double.MAX_VALUE);
        this.columnStanza.setCellValueFactory(param -> new SimpleObjectProperty((Object)((StanzaEntry)param.getValue()).getXml()));
        this.columnStanza.setCellFactory((Callback)new Callback<TableColumn<StanzaEntry, String>, TableCell<StanzaEntry, String>>(){

            public TableCell<StanzaEntry, String> call(TableColumn<StanzaEntry, String> columnStanza) {
                TableCell<StanzaEntry, String> cell = new TableCell<StanzaEntry, String>(){

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        this.setTooltip(null);
                        if (!empty) {
                            this.setText(item);
                        }
                    }
                };
                cell.getStyleClass().add((Object)"stanza-cell");
                return cell;
            }
        });
        this.columnFrom.setCellValueFactory(param -> new SimpleObjectProperty((Object)((StanzaEntry)param.getValue()).getFrom()));
        this.columnFrom.setCellFactory((Callback)new Callback<TableColumn<StanzaEntry, Jid>, TableCell<StanzaEntry, Jid>>(){

            public TableCell<StanzaEntry, Jid> call(TableColumn<StanzaEntry, Jid> columnStanza) {
                return new TableCell<StanzaEntry, Jid>(){

                    protected void updateItem(Jid item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        if (!empty && item != null) {
                            this.setText(item.toString());
                        }
                    }
                };
            }
        });
        this.columnTo.setCellValueFactory(param -> new SimpleObjectProperty((Object)((StanzaEntry)param.getValue()).getTo()));
        this.columnTo.setCellFactory((Callback)new Callback<TableColumn<StanzaEntry, Jid>, TableCell<StanzaEntry, Jid>>(){

            public TableCell<StanzaEntry, Jid> call(TableColumn<StanzaEntry, Jid> columnStanza) {
                return new TableCell<StanzaEntry, Jid>(){

                    protected void updateItem(Jid item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        if (!empty && item != null) {
                            this.setText(item.toString());
                        }
                    }
                };
            }
        });
        this.txtInbound.setText("");
        Platform.runLater(() -> this.stanzaTableView.scrollTo(Integer.MAX_VALUE));
    }

    @FXML
    public void filter() {
        this.filteredList.setPredicate(this::isVisible);
    }

    @FXML
    public void clear() {
        this.viewModel.stanzas.clear();
    }

    void addStanza(StanzaEntry stanzaEntry) {
        this.viewModel.stanzas.add((Object)stanzaEntry);
        if (this.viewModel.stanzas.size() == 1) {
            this.stanzaTableView.getSelectionModel().select(0);
        }
        this.viewModel.stanzas.remove(0, this.viewModel.stanzas.size() - 200);
    }

    private boolean isVisible(StanzaEntry stanzaEntry) {
        return (this.cbInbound.isSelected() && stanzaEntry.isInbound() || this.cbOutbound.isSelected() && !stanzaEntry.isInbound()) && (this.searchField.getText() == null || this.searchField.getText().equals("") || stanzaEntry.getXml().contains(this.searchField.getText()) && !this.cbIgnoreCase.isSelected() || DebugController.containsIgnoreCase(stanzaEntry.getXml(), this.searchField.getText()) && this.cbIgnoreCase.isSelected());
    }

    void appendTextInbound(String s) {
        Platform.runLater(() -> this.txtInbound.appendText(s));
    }

    void appendTextOutbound(String s) {
        Platform.runLater(() -> this.txtOutbound.appendText(s));
    }

    public void clearOutbound(ActionEvent actionEvent) {
        this.txtOutbound.clear();
    }

    public void clearInbound(ActionEvent actionEvent) {
        this.txtInbound.clear();
    }

    public void copyToClipboard(ActionEvent actionEvent) {
        StringBuilder sb = new StringBuilder();
        for (StanzaEntry stanzaEntry : this.filteredList) {
            sb.append(stanzaEntry).append('\n');
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        StringSelection strSel = new StringSelection(sb.toString());
        clipboard.setContents(strSel, null);
    }
}

