/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.debug.gui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

final class LogFormatter
extends SimpleFormatter {
    LogFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
        LocalDateTime resultDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(record.getMillis()), ZoneId.systemDefault());
        sb.append(dateTimeFormatter.format(resultDate)).append(' ').append(record.getLevel()).append("  ").append(this.formatMessage(record));
        if (record.getThrown() != null) {
            sb.append('\n');
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            record.getThrown().printStackTrace(printWriter);
            sb.append(stringWriter.toString());
        }
        sb.append('\n');
        return sb.toString();
    }
}

