/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.debug.gui;

import java.time.LocalDateTime;
import java.time.ZoneId;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.model.StreamError;

final class StanzaEntry {
    private final boolean inbound;
    private final String xml;
    private final Object stanza;
    private final LocalDateTime date;

    public StanzaEntry(boolean inbound, String xml, Object stanza) {
        this.inbound = inbound;
        this.xml = xml;
        this.stanza = stanza;
        this.date = LocalDateTime.now(ZoneId.systemDefault());
    }

    public String getXml() {
        return this.xml;
    }

    public Object getStanza() {
        return this.stanza;
    }

    public boolean isInbound() {
        return this.inbound;
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public Jid getFrom() {
        return this.stanza instanceof Stanza ? ((Stanza)this.stanza).getFrom() : null;
    }

    public Jid getTo() {
        return this.stanza instanceof Stanza ? ((Stanza)this.stanza).getTo() : null;
    }

    public boolean isError() {
        return this.stanza instanceof IQ && ((IQ)this.stanza).getType() == IQ.Type.ERROR || this.stanza instanceof Message && ((Message)this.stanza).getType() == Message.Type.ERROR || this.stanza instanceof Presence && ((Presence)this.stanza).getType() == Presence.Type.ERROR || this.stanza instanceof StreamError;
    }

    public String toString() {
        return (this.inbound ? "IN : " : "OUT: ") + this.xml;
    }
}

